/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SWTSystemColor.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;


/**
 * Handle SWT System Color definition.
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SWTSystemColor 
{
  /** Convert a SWT Color to RGBA opaque value */
  protected static int ToRGBA( Color c )
  {
    return RGBA.Get( c.getRed(), c.getGreen(), c.getBlue() );
  }
  
  /** 
   * Return system color defined in a device using IGC.C_xxx constant id.
   * @param device device used to get system color.
   * @param id IGC.C_xxx constant id.
   * @return rgba color defined by this device.
   */
  public static int GetSystemColor( Device device, int id )
  {
    switch( id )
    {
    case IGC.C_WIDGET_DARK_SHADOW : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_WIDGET_DARK_SHADOW ) );
    case IGC.C_WIDGET_NORMAL_SHADOW :
      return ToRGBA( device.getSystemColor( SWT.COLOR_WIDGET_NORMAL_SHADOW ) );
    case IGC.C_WIDGET_LIGHT_SHADOW : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_WIDGET_LIGHT_SHADOW ) );
    case IGC.C_WIDGET_HIGHLIGHT_SHADOW: 
      return ToRGBA( device.getSystemColor( SWT.COLOR_WIDGET_HIGHLIGHT_SHADOW ) );
    case IGC.C_WIDGET_FOREGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_WIDGET_FOREGROUND ) );
    case IGC.C_WIDGET_BACKGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_WIDGET_BACKGROUND ) );
    case IGC.C_WIDGET_BORDER : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_WIDGET_BORDER ) );
    case IGC.C_LIST_FOREGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_LIST_FOREGROUND ) );
    case IGC.C_LIST_BACKGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_LIST_BACKGROUND ) );
    case IGC.C_LIST_SELECTION_BACKGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_LIST_SELECTION ) );
    case IGC.C_LIST_SELECTION_TEXT : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_LIST_SELECTION_TEXT ) );
    case IGC.C_INFO_FOREGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_INFO_FOREGROUND ) );
    case IGC.C_INFO_BACKGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_INFO_BACKGROUND ) );
    case IGC.C_TITLE_FOREGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_TITLE_FOREGROUND ) );
    case IGC.C_TITLE_BACKGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_TITLE_BACKGROUND ) );
    case IGC.C_TITLE_BACKGROUND_GRADIENT : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_TITLE_BACKGROUND_GRADIENT ) );
    case IGC.C_TITLE_INACTIVE_FOREGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_TITLE_INACTIVE_FOREGROUND ) );
    case IGC.C_TITLE_INACTIVE_BACKGROUND : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_TITLE_INACTIVE_BACKGROUND ) );
    case IGC.C_TITLE_INACTIVE_BACKGROUND_GRADIENT : 
      return ToRGBA( device.getSystemColor( SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT ) );      
    default:
      if( (id&0x1)==0 ) {
        System.err.println("SWTSystemColor.GetSystemColor( id="+id+ "): unknown id, return white.");
        return RGBA.WHITE;
      } else {
        System.err.println("SWTSystemColor.GetSystemColor( id="+id+ "): unknown id, return black.");
        return RGBA.BLACK;
      }
    }
  }
}
