/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Ellipse.java,v 1.4 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.EllipseAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.IVector;


/**
 * General Ellipse shape and/ord path. Can hold full ellipse including sloped ellipse,
 * or arc of ellipse.
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Ellipse implements IShape, IShapeFiller, IPath, IPathElement
{
  /**store current ellipse definition in pixel coordinates*/
  protected EllipseAlg def_;

  private Ellipse() {}
  
  /**
   * Create a sloped arc of ellipse.
   * @param cx X coordinate of ellipse center (in pixel).
   * @param cy Y coordinate of ellipse center (in pixel).
   * @param rx_angle_ angle of ellipse X axis and pixel X axis (radian).
   * @param rx ellipse X axis radius.
   * @param ry ellipse Y axis radius.
   * @param start_angle start angle of arc (radian) from pixel X axis.
   * @param arc_length signed arc length (radian) from start_angle. 
   */
  public Ellipse( int cx, int cy, double rx_angle, int rx, int ry, double start_angle, double arc_length )
  {
    setArc( cx, cy, rx_angle, rx, ry, start_angle, arc_length );
  }
  /**
   * Create full sloped ellipse. 
   * @param cx X coordinate of ellipse center (in pixel).
   * @param cy Y coordinate of ellipse center (in pixel).
   * @param rx_angle_ angle of ellipse X axis and pixel X axis (radian).
   * @param rx ellipse X axis radius.
   * @param ry ellipse Y axis radius.
   */
  public Ellipse( int cx, int cy, double rx_angle, int rx, int ry )
  {
    setEllipse( cx, cy, rx_angle, rx, ry );
  }  
  /**
   * Create pixel X axis aligned ellipse.
   * @param cx X coordinate of ellipse center (in pixel).
   * @param cy Y coordinate of ellipse center (in pixel).
   * @param rx X axis radius of ellipse.
   * @param ry Y axis radius of ellipse.
   */
  public Ellipse( int cx, int cy, int rx, int ry )
  {
    setEllipse( cx, cy, rx, ry );
  }
  /**
   * Create a copy of given ellipse.
   */
  public Ellipse( Ellipse e ) 
  {
    setEllipse( e );
  }
  
  /**
   * Change ellipse to a X pixel axis aligned ellipse.
   * @param cx X coordinate of ellipse center (in pixel).
   * @param cy Y coordinate of ellipse center (in pixel).
   * @param rx X axis radius of ellipse.
   * @param ry Y axis radius of ellipse.
   */
  public void setEllipse( int cx, int cy, int rx, int ry )
  {
    if( def_==null ) 
    {
      def_ = new EllipseAlg( cx,cy, 0, rx, ry );
    } else {
      def_.setEllipse( cx,cy, 0, rx, ry );
    }
  }
  /**
   * Create full sloped ellipse. 
   * @param cx X coordinate of ellipse center (in pixel).
   * @param cy Y coordinate of ellipse center (in pixel).
   * @param rx_angle_ angle of ellipse X axis and pixel X axis (radian).
   * @param rx ellipse X axis radius.
   * @param ry ellipse Y axis radius.
   */
  public void setEllipse( int cx, int cy, double rx_angle, int rx, int ry )
  {
    if( def_==null ) {
      def_ = new EllipseAlg( cx,cy, rx_angle, rx,ry );
    } else {
      def_ .setEllipse( cx,cy, rx_angle, rx,ry );
    }
  }
  /**
   * Create a sloped arc of ellipse.
   * @param cx X coordinate of ellipse center (in pixel).
   * @param cy Y coordinate of ellipse center (in pixel).
   * @param rx_angle_ angle of ellipse X axis and pixel X axis (radian).
   * @param rx ellipse X axis radius.
   * @param ry ellipse Y axis radius.
   * @param start_angle start angle of arc (radian) from pixel X axis.
   * @param arc_length signed arc length (radian) from start_angle. 
   */
  public void setArc( int cx, int cy, double rx_angle, int rx, int ry, double start_angle, double arc_length )
  {
    if( def_ ==null ) {
      def_ = new EllipseAlg( cx,cy, rx_angle, rx,ry, start_angle, arc_length );
    } else {
      def_.setArc( cx,cy, rx_angle, rx,ry, start_angle, arc_length );
    }
  }
  /**
   * Copy parameter from given ellipse, does nothing if e is null.
   */
  public void setEllipse( Ellipse e )
  {
    if( def_==null )
    {
      def_ = new EllipseAlg( e.def_ );
    } else {
      def_.setEllipse( e.def_ );
    }
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IShape#copyShape()
   */
  public IShape copyShape() {
    return new Ellipse(this);
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IShape#contains(int, int)
   */
  public boolean contains(int x, int y) {
    return def_.contains( x, y );
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IShape#contains(org.eclipse.tptp.platform.report.igc.internal.IPoint)
   */
  public boolean contains(IPoint p) { return contains( p.getX(), p.getY()); }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IShape#getBounds()
   */
  public IRect getBounds() {
    return def_.getBounds();
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IShapeFiller#fillShape(org.eclipse.tptp.platform.report.igc.internal.IGC, org.eclipse.tptp.platform.report.igc.internal.IBrush, org.eclipse.tptp.platform.report.igc.internal.IShape)
   */
  public boolean fillShape(IGC gc, IGCDirect gd, IBrush brush, IShape shape) 
  {
    if( !(shape instanceof Ellipse )) return false;
    if( brush!=null) brush.brushBegin( gc, gd );
    setupEllipseData( gd );
    dev_def_.fill( gd );
    if( brush!=null) brush.brushEnd();
    return true;
  }

  EllipseAlg dev_def_;
  private void setupEllipseData( IGCDirect gd )
  {
//System.out.println("SETUP Ellipse data to gc.usePixelCoords="+gc.usePixelCoordinates());    
    if( gd.usePixelCoordinates() ) {
      dev_def_=def_;
    } else {
      //must convert to device coordinates:
      int dcx =gd.devX(def_.getCenterX()), dcy=gd.devY(def_.getCenterY());
      int drx =gd.devX(def_.getRadiusX()), dry=gd.devY(def_.getRadiusY());
      if( dev_def_==null || dev_def_==def_ ) {
//System.out.println(" => new dev_def_ ellipse object.");        
        dev_def_ = new EllipseAlg( dcx,dcy,def_.getAngle(), drx,dry, def_.getArcStart(),def_.getArcLength());
      } else {
//System.out.println(" => resuse dev_def_ ellipse object.");
        dev_def_.setArc( dcx,dcy,def_.getAngle(), drx,dry, def_.getArcStart(),def_.getArcLength());
      }
    }
//System.out.println(" from ellipse="+def_);
//System.out.println(" to   ellipse="+dev_def_);
  }
  
  public boolean pathBegin( IGC gc, IGCDirect gd ) {
    give_path_element_=true;
    return true;
  }

  public void pathEnd() { give_path_element_=false; }

  protected boolean give_path_element_;
  
  public IPathElement nextPathElement() 
  {
    if( give_path_element_ ) {
      give_path_element_=false; //give it once only.
      return this;
    } 
    return null;
  }

  public IPathElement copyPathElement() {
    Ellipse e = new Ellipse();
    e.def_ = e.dev_def_ = dev_def_; //copy the one with device coordinates.
    return e;
  }

  public boolean pathElementBegin(IGC gc, IGCDirect gd) 
  {
    setupEllipseData( gd );
    return true;
  }

  public void pathElementEnd() {}

  public boolean nextPoint(IPoint point) {
    return dev_def_.nextPoint( point );
  }

  public void backTangent(IVector vector) {
    // TODO need to add this in EllipseAlg.model...
    throw new UnsupportedOperationException("backTangent() in Ellipse");
  }

  public void frontTangent(IVector vector) {
    // TODO need to add this in EllipseAlg.model...
    throw new UnsupportedOperationException("backTangent() in Ellipse");    
  }

}
