/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Font.java,v 1.3 2008/12/12 22:22:11 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.internal.IFont;

import com.ibm.icu.util.ULocale;


/**
 * Simple implementation of an IFont.
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Font implements IFont
{
  protected String script_;
  protected String name_;
  protected int size_;
  protected int style_;
  
  public Font( String script, String name, int height, int style )
  {
    setFont( script, name, height, style );
  }
  public Font( String name, int height, int style )
  {
    setFont( ULocale.getDefault().toString(), name, height, style );
  }
  public Font( IFont font )
  {
    script_=font.getFontScript();
    name_=font.getFontName();
    size_=font.getFontSize();
    style_=font.getFontStyle();
  }
  
  public String getFontName() { return name_; }
  public int getFontSize() { return size_; }
  public int getFontStyle() { return style_; }
  public String getFontScript() { return script_; }

  public void setFontScript( String script ) { script_=script; }
  public void setFontName( String name ) { name_=name; }
  public void setFontSize( int h ) { size_=h; }
  public void setFontStyle( int s ) { style_=s; }

  public void setFont( String script, String name, int height, int style )
  {
    script_=script;
    name_=name;
    size_=height;
    style_=style;
  }
  
  public IFont copy()
  {
    return new Font(this);
  }
  
  public String toString()
  {
    return super.toString()+"{name='"+name_+"' script="+script_+"' size="+size_+" style="+StrStyle(style_)+"}";
  }
  
  public static String StrStyle( int style )
  {
    if( style==IFont.NORMAL ) return "NORMAL";
    StringBuffer buf=new StringBuffer();
    if( (style&BOLD)!=0)  buf.append( "|BOLD" );
    if( (style&ITALIC)!=0) buf.append( "|ITALIC" );
    if( (style&UNDERLINE)!=0) buf.append( "|UNDERLINE" );
    if( (style&OVERLINE)!=0) buf.append( "|OVERLINE" );
    if( (style&STRIKE)!=0) buf.append( "|STRIKE" );
    if( (style&DASHED)!=0) buf.append( "|DASHED" );
    if( buf.length()==0 ) return "NORMAL";
    return buf.substring( 1, buf.length() );
  }
  
  /**
    * Checks if the current font style has one or more properties define by a mask.
    * @return true is _style have one (or more) _mask bit set.
    * For example HaveStyle( BOLD|UNDERLINE, UNDERLINE) return true.
    */
   public static boolean HaveStyle( int _style, int _mask )
   {
     return (_style&_mask)!=0;
   }
   
   /**
    * Checks if the font has one or more property style with a mask.
    * @return true if font have one (or more) style from given mask.
    */
   public boolean haveStyle( int style_mask ) 
   {
    return ((style_ & style_mask)!=0);    
   }
   
   /**
    * Add the given font style bit to the current font.
    * addStyle(NORMAL) have no effect.
    */
   public void addStyle( int style_mask )
   {
     style_ |= style_mask;
   }
   
   /**
    * remove from current font style the given bit mask.
    * (removeStyle(NORMAL) have no effet, to remove all style use setFontStyle(NORMAL).
    */
   public void removeStyle( int style_mask )
   {
     style_ &= (~ style_mask);
   }
     
}
