/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGradientGenerator.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

/**
 * This interface define a RGBA gradient generator.
 * RGBA color are requested using a parameter in the range [0..1], but can also
 * be out range, in this case gradient generator can choose to return transparent color,
 * or any color it want.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IGradientGenerator 
{
 /**
   * @return gradient RGBA color defined at given value of coeficient _k (mainly inside [0..1])
   */
  public int getRGBA( double _k );
  
  /**
   * @return true is current gradient contains transparency. Provide for caller who want to
   * optimize their code avoiding IGC.getPoint() call (or other something like this...).
   */
  public boolean containsTransparency();
}
