/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImageProxy.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import java.util.ArrayList;

import org.eclipse.tptp.platform.report.igc.internal.IImage;


/**
 * Simple (Silly?) implementation of IImage.
 * This image contains a set of image loader, as underlaying graphic system is needed
 * to really load image to know size or get pixel color.
 * The load of image is done on getHeight()/getWidth() or getPixel() request, on can
 * be done calling loadImage() method.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ImageProxy implements IImage
{
  public static interface ILoader
  {
    /** @return IImage for given proxy */
    public IImage loadImage( ImageProxy proxy );
    /** dispose loaded image */
    public void disposeImage( IImage loaded_ );
  }
  
  protected static ArrayList loaders_;

  protected int width_, height_;
  protected boolean resource_stream_;
  protected String url_;
  protected IImage loaded_;
  protected ILoader loader_;
  
  /** 
   * Create image proxy.
   * image is loaded at getWidth/getHeight/getPixel time.
//TODO: why not merged in URL?
   * @param resource_stream true if image is located in resource stream.
   * @param url url of image.
   */
  public ImageProxy( boolean resource_stream, String url )
  {
    width_=height_=-1;
    resource_stream_=resource_stream;
    url_=url;
  }
  /** image proxy created with a known width/height (trusted).
   * image is loaded a getPixel() time only.
   * @param w image width in pixel (<0 means don't know)
   * @param h image height in pixel (<0 means don't know).
//TODO: why not merged in URL?
   * @param resource_stream true if image is located in resource stream.
   * @param url url of image.
   */
  public ImageProxy( int w, int h, boolean resource_stream, String url )
  {
    width_=w;
    height_=h;
    resource_stream_=resource_stream;
    url_=url;
  }
  
  public boolean isResourceAsStream() { return resource_stream_; }
  public String getURL() { return url_; }
  
  public static void addLoader( ILoader l ) 
  {
    if( loaders_==null ) loaders_ = new ArrayList();
    loaders_.add( l );
  }
  public static boolean removeLoader( ILoader l ) 
  {
    if( loaders_==null ) return false;
    //if( loaders_==loader_) loader_=null;
    boolean res = loaders_.remove( l );
    if( loaders_.size()==0 ) loaders_=null;
    return res;
  }
  
  /** @return current loaded image, does not load image if it's not yet done. */
  public IImage getLoaded() { return loaded_; }
  /** @return true if proxy have loaded image */
  public boolean isLoaded() { return loaded_!=null; }
  
  public void setLoadedImage( IImage img, ILoader loader )  
  {
    if( loader_!=null) 
    {
      loader_.disposeImage( loaded_ );
    }
    loaded_=img;
    loader_=loader;
  }
  
  public void disposeImage()
  {
    setLoadedImage( null, null );
  }

  public boolean loadImage()
  {
    if( loaders_==null ) return false;
    for( int i=0; i<loaders_.size(); ++i )
    {
      ILoader il = (ILoader)loaders_.get(i);
      setLoadedImage( il.loadImage(this), il );
      if( loaded_!=null ) return true;
    }
    return false;
  }
  
  public int getWidth() {
    if( width_>=0 ) return width_;
    if( loaded_==null && !loadImage() ) return -1;
    return width_=loaded_.getWidth();    
  }  
  public int getHeight() {
    if( height_>=0 ) return width_;
    if( loaded_==null && !loadImage() ) return -1;
    return height_=loaded_.getHeight();    
  }
  
  public int getPixel(int x, int y) 
  {
    if( loaded_==null ) {
      if(!loadImage()) return RGBA.TRANSPARENT;
    }
    return loaded_.getPixel( x,y );
  }

}
