/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Oval.java,v 1.4 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.OvalAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.IVector;


/**
 * Oval Shape, an ellipse aligned to X,Y axis contained in a rectangle.
 * This can handle Oval arc also.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Oval implements IShape, IShapeFiller, IPath, IPathElement
{
  protected int cx_,cy_, rx_,ry_; //center and radii
  protected double arc_start_, arc_length_; //angle of arc start, and arc length.
  
  public Oval( int cx, int cy, int rx, int ry, double arc_start, double arc_length )
  {
    setArc( cx,cy, rx,ry, arc_start, arc_length );
  }
  public Oval( int cx, int cy, int rx, int ry )
  {
    setOval( cx, cy, rx, ry );
  }  
  public Oval( Oval o )
  {
    setOval( o );
  }
  
  public int getCenterX() { return cx_; }
  public int getCenterY() { return cy_; }
  public int getRadiusX() { return rx_; }
  public int getRadiusY() { return ry_; }
  
  public boolean isCircle() { return rx_==ry_; }
  
  public void setArc( int cx, int cy, int rx, int ry, double arc_start, double arc_length )
  {
    cx_=cx;cy_=cy; rx_=rx; ry_=ry;
    arc_start_=arc_start;
    arc_length_=arc_length;
  }
  public void setOval( int cx, int cy, int rx, int ry )
  {
    cx_=cx;cy_=cy; rx_=rx; ry_=ry;
    arc_start_=0.0;
    arc_length_=Radian._2PI;
  }
  public void setOval( Oval o ) 
  {
    cx_=o.cx_;cy_=o.cy_; rx_=o.rx_; ry_=o.ry_;
    arc_start_ = o.arc_start_;
    arc_length_= o.arc_length_;
  }
  
  public IShape copyShape() { return new Oval(this); }
  public IPathElement copyPathElement() { return new Oval(this); }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IShape#contains(int, int)
   */
  public boolean contains(int px, int py)
  {
    return OvalAlg.Contains( px,py, cx_,cy_,rx_,ry_,arc_start_,arc_length_ );    
  }

  public boolean contains( IPoint p )
  { 
    return p!=null && contains( p.getX(), p.getY());
  }
  
  public IRect getBounds() 
  {
    int rx = Math.abs( rx_ );
    int ry = Math.abs( ry_ );
    return new Rect( cx_-rx, cy_-ry, 2*rx, 2*ry );
  }
  
  public boolean fillShape(IGC gc, IGCDirect gd, IBrush brush, IShape shape)
  {
    if( !(shape instanceof Oval )) return false;
    brush.brushBegin( gc, gd );
    
    if( gd.usePixelCoordinates() )
    {
      OvalAlg.FillArc( gd, cx_, cy_, rx_, ry_, arc_start_, arc_length_ );
    } else {
      OvalAlg.FillArc( gd, gd.devX(cx_), gd.devY(cy_), gd.devX(rx_), gd.devY(ry_), arc_start_, arc_length_ );
    }
    brush.brushEnd();
    return true;
  }
  
  protected boolean give_path_element_;
  
  public boolean pathBegin( IGC gc, IGCDirect gd ) {
    give_path_element_=true;
    return true;
  }
  public void pathEnd() {
    give_path_element_=false;    
  }
  public IPathElement nextPathElement() {
    if( give_path_element_ )
    {
      give_path_element_=false;//only once, otherwise this is named infinite loop.
      return this;
    }
    return null; 
  }

  protected OvalAlg alg_;
  public boolean pathElementBegin( IGC gc, IGCDirect gd ) {
    alg_ = new OvalAlg( gd.devX(cx_),gd.devY(cy_), gd.devX(rx_), gd.devY(ry_), arc_start_, arc_length_ );
    return true;
  }
  
  public void pathElementEnd() {
    alg_=null;
  }
  public boolean nextPoint(IPoint point) {
    return alg_.nextPoint(point);
  }
  public void backTangent(IVector vector) {
    alg_.getCurrentTangent( vector );
  }
  public void frontTangent(IVector vector) {
    alg_.getCurrentTangent( vector );
  }
  
  public String toString()
  {
    return super.toString()+"{ctr="+cx_+","+cy_+" radius="+rx_+","+ry_+" arc_start="+arc_start_+" arc_length="+arc_length_+"}";
  }

}
