/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PolygonSpline3.java,v 1.4 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.Spline3Alg;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;
import org.eclipse.tptp.platform.report.igc.internal.IVector;


/**
 * This Path (PathElement) is Splines with 3 controls points getted from a IPolygon.
 * Polygon must have at least 3 points. Path pass through first and last polygon point
 * and through midle of inner segment of polygon.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class PolygonSpline3 implements IPath, IPathElement
{
  protected IPolygon poly_;
  
  /** Create a spline polygon */
  public PolygonSpline3( IPolygon _poly )
  {
    poly_=_poly;
  }
  /** Create an empty spline polygon, use setPolygon() */
  public PolygonSpline3() {}
  
  /** @return the current used polygon */
  public IPolygon getPolygon() { return poly_; }
  
  /** change current polygon */
  public void setPolygon( IPolygon p ) { poly_=p; }
  
  protected boolean give_next_path_element_;
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPath#pathBegin(org.eclipse.tptp.platform.report.igc.internal.IGC, org.eclipse.tptp.platform.report.igc.internal.IGCDirect)
   */
  public boolean pathBegin(IGC gc, IGCDirect gd) 
  {
    give_next_path_element_ = poly_!=null && poly_.getPolySize()>3 ;
    return give_next_path_element_;
  }
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPath#pathEnd()
   */
  public void pathEnd() { give_next_path_element_=false; }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPath#nextPathElement()
   */
  public IPathElement nextPathElement() 
  {
    if( give_next_path_element_ ) 
    {
      give_next_path_element_=false;
      return this;
    }
    return null;
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#copyPathElement()
   */
  public IPathElement copyPathElement() {
    return new PolygonSpline3( new Polygon(poly_) );
  }
  
  protected int curr_index_,state_;
  protected int dpoints_[];
  protected Spline3Alg spline_;
  

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#pathElementBegin(org.eclipse.tptp.platform.report.igc.internal.IGC, org.eclipse.tptp.platform.report.igc.internal.IGCDirect)
   */
  public boolean pathElementBegin(IGC gc, IGCDirect gd) 
  {
    if( poly_==null || poly_.getPolySize()<3 ) return false;
    int size = poly_.getPolySize();
    curr_index_ = 0;
    //convert polygon to device coordinates
    int index=0;
    if( poly_.isPolyClosed() )
    {
       //closed by have same first/last point ?
       if( poly_.getPolyX( 0 )==poly_.getPolyX( size-1 )
         &&poly_.getPolyY( 0 )==poly_.getPolyY( size-1 ) )
       {
         size--;
       }
      dpoints_ = new int[4*size+2];
      int lx= gd.devX( poly_.getPolyX( size-1 ) );
      int ly= gd.devY( poly_.getPolyY( size-1 ) );
      for( int i=0; i<size; i++ )
      {
        int px= gd.devX( poly_.getPolyX( i ) );
        int py= gd.devY( poly_.getPolyY( i ) );
        dpoints_[index++] = (lx+px)>>1;
        dpoints_[index++] = (ly+py)>>1;
        dpoints_[index++] = px;
        dpoints_[index++] = py;
        lx=px;
        ly=py;
      }
      dpoints_[index++] = dpoints_[0];
      dpoints_[index++] = dpoints_[1];
    }
    else
    {
      dpoints_ = new int[2*(2*(size-3)+3)];
      dpoints_[index++] = gd.devX( poly_.getPolyX(0) );
      dpoints_[index++] = gd.devY( poly_.getPolyY(0) );
      int lx = dpoints_[index++] = gd.devX( poly_.getPolyX(1) );
      int ly = dpoints_[index++] = gd.devY( poly_.getPolyY(1) );
      for( int i=2; i<size-1; i++ )
      {
        int px= gd.devX( poly_.getPolyX( i ) );
        int py= gd.devY( poly_.getPolyY( i ) );
        dpoints_[index++] = (lx+px)>>1;
        dpoints_[index++] = (ly+py)>>1;
        dpoints_[index++] = px;
        dpoints_[index++] = py;
        lx=px;
        ly=py;
      }
      dpoints_[index++] = gd.devX( poly_.getPolyX(size-1) );
      dpoints_[index++] = gd.devY( poly_.getPolyY(size-1) );
    }
    if( spline_==null) spline_ = new Spline3Alg();
    state_=0;
    return true;
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#pathElementEnd()
   */
  public void pathElementEnd() 
  {
    dpoints_=null;
    state_=2;
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#nextPoint(org.eclipse.tptp.platform.report.igc.internal.IPoint)
   */
  public boolean nextPoint(IPoint point) 
  {
    if( state_==0 )
    {
      //start spline..
      spline_.setSpline( dpoints_[curr_index_++], dpoints_[curr_index_++], 
                         dpoints_[curr_index_++], dpoints_[curr_index_++], 
                         dpoints_[curr_index_  ], dpoints_[curr_index_+1] );
      state_=1;
      return spline_.nextPoint( point );
    }
    else if ( state_==1 )
    {
      if( spline_.nextPoint( point ) ) return true;
      //next spline;
      for(;;)
      {
        if( curr_index_ >= dpoints_.length-4 ) 
        {
          //end polygon
          state_=2;
          return false;
        }
        spline_.setSpline( dpoints_[curr_index_++], dpoints_[curr_index_++], 
                           dpoints_[curr_index_++], dpoints_[curr_index_++], 
                           dpoints_[curr_index_  ], dpoints_[curr_index_+1] );
        //consume firt point as it's generated by last spline segment
        if( !spline_.nextPoint(null) ) continue;
        if( spline_.nextPoint(point)) return true;
      }
    }
    else
    {
      return false;
    }
  }
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#backTangent(org.eclipse.tptp.platform.report.igc.internal.IVector)
   */
  public void backTangent(IVector vector) 
  {
    spline_.backTangent( vector );
  }
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#frontTangent(org.eclipse.tptp.platform.report.igc.internal.IVector)
   */
  public void frontTangent(IVector vector) 
  {
    spline_.frontTangent( vector );
  }
  
  
}
