/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Radian.java,v 1.2 2008/05/23 14:11:55 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

/**
 * Helper class for angle conversion and constants.
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Radian 
{
  public static final double  _PI = Math.PI;
  public static final double _2PI = 2*Math.PI;
  public static final double _PI2 = Math.PI/2;
  public static final double _3PI2= 3*Math.PI/2;
  public static final double _PI4 = Math.PI/4;
  public static final double _3PI4= 3*Math.PI/4;
  public static final double _5PI4= 5*Math.PI/4;
  public static final double _7PI4= 7*Math.PI/4;
  public static final double _PI3 = Math.PI/3;
  public static final double _2PI3 = 2*Math.PI/3;
  public static final double _4PI3 = 4*Math.PI/3;
  public static final double _5PI3 = 5*Math.PI/3;
  public static final double _PI6 = Math.PI/6;
  public static final double _5PI6 = 5*Math.PI/6;
  public static final double _7PI6 = 7*Math.PI/6;
  public static final double _11PI6 = 11*Math.PI/6;
  public static final double _PI8 = Math.PI/8;
  public static final double _3PI8 = 3*Math.PI/8;
  public static final double _5PI8 = 5*Math.PI/8;
  public static final double _7PI8 = 7*Math.PI/8;
  public static final double _9PI8 = 9*Math.PI/8;
  public static final double _11PI8 = 11*Math.PI/8;
  public static final double _13PI8 = 13*Math.PI/8;
  public static final double _15PI8 = 15*Math.PI/8;
  
  /** @return angle between [0..2PI[ */
  public static double normalize( double angle )
  {
    while(angle<0) angle+=_2PI;
    while(angle>=_2PI) angle-=_2PI;
    return angle;
  }
    
  /** @return convert radian to degree */
  public static double R2D( double radian )
  {
    return radian*180/Math.PI;
  }
  /** @return convert radian to degree */
  public static int iR2D( double radian )
  {
    return (int)Math.round(radian*180/Math.PI);
  }
  
  /** @return convert degree to radian */
  public static double D2R( double degree )
  {
    return degree*Math.PI/180.0;
  }
  /** @return convert degree to radian */
  public static double D2R( int degree )
  {
    return degree*Math.PI/180.0;
  }
}
