/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Rect.java,v 1.3 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.ISize;

/**
 * Implementation of an IRect, with lots of
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Rect implements IRect, IPath
{
  protected int x_, y_, w_, h_ ;
  
  /** Create 0,0,0,0 rectagle */
  public Rect()
  {
    x_=y_=w_=h_=0;
  }
  /** Create a rectangle */
  public Rect( int _x, int _y, int _w, int _h )
  {
    x_=_x; y_=_y; w_=_w; h_=_h;
  }
  /** Create a rectangle copying value */
  public Rect( IRect _r )
  {
    setRect(_r);
  }
  /** Create a rectangle copying value from given one and applying grow() on bounds*/
  public Rect( IRect _r , int _grow )
  {
    setRect( _r, _grow );
  }
  
  public IRect getBounds() { return this; }
  public IShape copyShape() { return new Rect(this); }
  
  /** @return x of rectangle, top left corner if w>0 and h>0 */
  public int x() { return x_; }
  /** @return y of rectangle, top left corner if w>0 and h>0 */
  public int y() { return y_; }
  /** @return width of the rectangle */
  public int w() { return w_; }
  /** @return height of the rectangle */
  public int h() { return h_; }
   
  public int getX() { return x_; }
  public int getY() { return y_; }
  public int getW() { return w_; }
  public int getH() { return h_; }
  
  /** @return left side of the rectangle */
  public int left() 
  {
    if( w_ >=0 ) return x_; else return x_+w_;
  }
  /** @return right side of the rectangle */
  public int right()
  {
    if( w_ >=0 ) return x_+w_; else return x_;
  }
  /** @return top of the rectangle */
  public int top()
  {
    if( h_ >=0 ) return y_; else return y_+h_;    
  }
  /** @return bottom of the rectangle */
  public int bottom()
  {
    if( h_ >=0 ) return y_+h_; else return y_;
  }
  /** @return center of the rectangle, allocate a Point */
  public Point center()
  {
    return new Point( centerX(), centerY() );
  }
  /** @return x of the center */
  public int centerX() { return x_+(w_>>1); }
  /** @return y of the center */
  public int centerY() { return y_+(h_>>1); }
  
  
  /** Change x value of rectangle */
  public void setX( int _x ) { x_=_x; }
  /** Change y value of rectangle */
  public void setY( int _y ) { y_=_y; }
  /** Change width of the rectangle */
  public void setWidth( int _w ) { w_=_w; }
  /** Change height of the rectangle */
  public void setHeight( int _h ) { h_=_h; }
  /** Change width and height of the rectangle */
  public void setSize( int _w, int _h ) { w_=_w; h_=_h; }
  /** Change width and height of the rectangle using swt's Point. */
  public final void setSize( IPoint _size ) { setSize(_size.getX(),_size.getY()); }
  public final void setSize( ISize  _size ) { setSize(_size.getW(),_size.getH()); }
  /** Change x and y value of rectangle */
  public void setLocation( int _x, int _y ) { x_=_x; y_=_y; }
  /** change x and y value of rectangle using swt's point */
  public final void setLocation( IPoint _p ) { setLocation( _p.getX(), _p.getY() ); }
 

  /**Change left side of the rectangle, right side is not affected, may change width. */
  public void setLeft( int _l )
  {
    int r = right();
    x_ = _l;
    w_ = r-_l;
  }
  /** Change right side of the rectangle, left side is not affected, may change width. */
  public void setRight( int _r )
  {
    int l = left();
    x_ = l;
    w_ = _r-l;
  }
  /** Change top side of the rectangle, bottom is not affected, mau change height */
  public void setTop( int _t )
  {
    int b = bottom();
    y_ = _t;
    h_ = b-_t;
  }
  /** Change bottom side of the rectangle, top is not affected, may change height */
  public void setBottom( int _b )
  {
    int t = top();
    y_ = t;
    h_ = _b-t;
  }
  /** change all bounds using same amount, positive value make bigger rectangle */
  public void grow( int _amount )
  {
    x_ -= _amount; w_ += 2*_amount;
    y_ -= _amount; h_ += 2*_amount;
  }
  /** change all bounds using same amount, positive value make smaller rectangle */
  public void shrink( int _amount )
  {
    x_ += _amount; w_ -= 2*_amount;
    y_ += _amount; h_ -= 2*_amount;
  }
  /**
   * @return true if points (px,py) is inside rectangle (lx,ty,w,h), excluding border.
   */
  public static boolean Contains( int _lx, int _ty, int _w, int _h, int _px, int _py )
  {
    if( _px < _lx ) return false;
    if( _px > (_lx+_w)) return false;
    if( _py < _ty ) return false;
    if( _py > (_ty+_h)) return false;
    return true;
  }
  /**
   * @return true if points (px,py) is inside rectangle _r, excluding border.
   */
  public static boolean Contains( IRect _r,  int _px, int _py )
  {
    if( _px < _r.getX() ) return false;
    if( _px > (_r.getX()+_r.getW())) return false;
    if( _py < _r.getY() ) return false;
    if( _py > (_r.getY()+_r.getH())) return false;
    return true;
  }
 
  
  /** @return true is point is inside rectangle.
   * border of the rectangle is included in test. */
  public boolean contains( int _px, int _py )
  {
    if( _px <= left() ) return false;
    if( _px >= right() ) return false;
    if( _py <= top() ) return false;
    if( _py >= bottom() ) return false;
    return true;
  }
  /** @see #contains */
  public final boolean contains( IPoint _p ) 
  {
    if( _p==null ) return false;
    return contains( _p.getX(), _p.getY() );
  }  

  /** Change rectangle values */
  public void setRect( int _x, int _y, int _w, int _h )
  {
    x_=_x; y_=_y; w_=_w; h_=_h;
  }
  /** Change rectangle values */
  public void setRect( IRect _r )
  {
    if( _r==null )
    {
      x_=y_=w_=h_=0;
    } else {
      x_=_r.getX(); y_=_r.getY(); w_=_r.getW(); h_=_r.getH();
    }
  }
  /** Copy rectangle from given one and change bounds using grow()  */
  public void setRect( IRect _r, int _grow )
  {
    setRect( _r );
    grow( _grow );
  }
  
  /** 
   * Normalize rectangle, set width and height >=0.
   * @return this.
   */
  public Rect normalize()
  {
    if( w_ < 0 ) { x_ += w_; w_=-w_; }
    if( h_ < 0 ) { y_ += h_; h_=-h_; }
    return this;
  }
  
  /** Move rectangle to position */
  public void moveTo( int _x, int _y )
  {
    x_=_x; y_=_y;
  }
  /** Move rectangle by delta */
  public void moveBy( int _dx, int _dy )
  {
    x_+=_dx; y_+=_dy;
  }
  /** Move center of rectangle to given position */
  public void moveCenter( int _cx, int _cy )
  {
    x_ = _cx-(w_>>1);
    y_ = _cy-(h_>>1);
  }
  /** Move center of rectangle to given position */
  public final void moveCenter( IPoint _p )
  {
    moveCenter( _p.getX(), _p.getY() );
  }
  
  /** Setup this rect with the intersection area of this and parameter.
   * return width or height==0 if rectangle doesn't intersects.
   * @return this.
   */
  public Rect intersection( IRect _r )
  {
    Rect r = new Rect( _r );
    int left = Math.max( this.left(),   r.left()   );
    int top  = Math.max( this.top(),    r.top()    );
    int right= Math.min( this.right(),  r.right()  );
    int bottom=Math.min( this.bottom(), r.bottom() );
    x_ = left;
    y_ = top;
    w_ = Math.max( 0, right-left );
    h_ = Math.max( 0, bottom-top ); 
    return this;
  }
  
  /** Setup this rect with the union of this and parameter.
   * @return this.
   */
  public Rect union( IRect _r )
  {
    Rect r = new Rect(_r);
    int left = Math.min( this.left(),   r.left()  );
    int top  = Math.min( this.top(),    r.top()   );
    int right= Math.max( this.right(),  r.right() );
    int bottom=Math.max( this.bottom(), r.bottom() );
    x_ = left;
    y_ = top;
    w_ = Math.max( 0, right-left );
    h_ = Math.max( 0, bottom-top );
    return this;
  }
  
  /**@return the intersection area of the both rectangle, this is a new allocated rectangle.
   */
  public static Rect Intersection( Rect _r1, Rect _r2 )
  {
    Rect r = new Rect(_r1);
    return r.intersection( _r2 );
  }
  
  /** @return the intersection area of both rectangle, null for no intersection */
  public static Rect Intersection( int x1, int y1, int w1, int h1,  int x2, int y2, int w2, int h2 )
  {
    int l1,r1,t1,b1,  l2,r2,t2,b2;
    if( w1 >= 0 ) { l1=x1; r1=x1+w1; } else { l1=x1+w1; r1=x1; }
    if( h1 >= 0 ) { t1=y1; b1=y1+h1; } else { t1=y1+h1; b1=y1; }
    if( w2 >= 0 ) { l2=x2; r2=x2+w2; } else { l2=x2+w2; r2=x2; }
    if( h2 >= 0 ) { t2=y2; b2=y2+h2; } else { t2=y2+h2; b2=y2; }
    
    int left = Math.max( l1, l2 );
    int right= Math.min( r1, r2 );
    int w = right-left;
    if( w < 0 ) return null;
    
    int top   = Math.max( t1, t2 );
    int bottom= Math.min( b1, b2 );
    int h     = bottom-top ;
    if( h < 0 ) return null;
    
    return new Rect(left,top,w,h);
  }
  
   /** @return bounding rectangle of both given rectangle, this is a new allocated rects */
  public static Rect Union( Rect _r1, Rect _r2 )
  {
    Rect r = new Rect( _r1 );
    return r.union( _r2 );
  }
  
  /** return rectangle as "X,Y,WxH" */
  public String toString()
  {
    String s = super.toString()+"{"+x_+","+y_+","+w_+"x"+h_+"}";
    return s;
  }
  
  /**
   * @return true if given object is equals (x,y,w,h) to current object. Object can be a swt.Rectangle
   * or Rect
   */
  public boolean equals( Object o )
  {
    if( o==this) return true;
    if( o instanceof IRect ) 
    { 
      Rect or = (Rect)o;
      return ( or.getX() == x_ ) && (or.getY() == y_ ) && (or.getH() == h_) && (or.getW() == w_);
    }
    return false;
  }
  
  protected int dx_,dy_,dX_,dY_,pe_;
  protected Segment segment_;
  
  public boolean pathBegin( IGC gc, IGCDirect gd ) {
    dx_ = gd.devX(x_);     dy_ = gd.devY(y_);
    dX_ = dx_+gd.devX(w_); dY_ = dy_+gd.devY(h_);
    pe_=0;
    segment_ = new Segment();
    return true;
  }
  
  public void pathEnd() { segment_=null; }
  
  public IPathElement nextPathElement() 
  {
    switch( pe_ )
    {   
    case 0: segment_.setLine( dx_,dy_,dX_,dy_); pe_=1; return segment_;
    case 1: segment_.setLine( dX_,dy_+1,dX_,dY_-1); pe_=2; return segment_;
    case 2: segment_.setLine( dX_,dY_,dx_,dY_); pe_=3; return segment_;
    case 3: segment_.setLine( dx_,dY_-1,dx_,dy_+1); pe_=4; return segment_;
    default : return null;
    }
  }
  
  /** @return X coordinate of rectangle's center */
  public static int CenterX( IRect r ) { return r.getX() + r.getW()/2; }
  /** @return Y coordinate of rectangle's center */
  public static int CenterY( IRect r ) { return r.getY() + r.getH()/2; }
  /** @return rightest X coordinate of rectangle */
  public static int Right( IRect r )  { int x=r.getX(); return Math.max( x, x+r.getW() ); }
  /** @return leftest X coordinate of rectangle */
  public static int Left( IRect r ) { int x=r.getX(); return Math.min( x, x+r.getW() ); }
  /** @return topest Y coordinate of rectangle (in the meaning of Y screen coordinates) */
  public static int Top( IRect r ) { int y=r.getY(); return Math.min( y, y+r.getH() ); }
  /** @return leftest X coordinate of rectangle */
  public static int Bottom( IRect r ) { int y=r.getY(); return Math.max( y, y+r.getH() ); }
}
