/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RoundedRect.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.CircleAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.OvalAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;


/**
 * Example of "composite" path using circle/ellipse arc and segments.
 * This Path is also not an IPathElement.
 * But as it's a IShape it can be filled.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class RoundedRect implements IPath, IShape, IShapeFiller
{
  protected int x_,y_,w_,h_,rx_,ry_;
  
  /**
   * Create a RoundedRect using circle as corners
   */
  public RoundedRect( int x, int y, int w, int h, int radius )
  {
    setRoundedRect( x, y, w, h, radius );
  }
  /**
   * Create a RoundedRect from a rectangle and a radius.
   */
  public RoundedRect( IRect rect, int radius )
  {
    setRoundedRect( rect, radius );
  }
  /**
   * Create rounded rect with different X and Y axis radius for rounded corners.
   */
  public RoundedRect( int x, int y, int w, int h, int rx, int ry )
  {
    setRoundedRect( x, y, w, h, rx, ry );
  }
  /**
   * Create rounded rect with different X and Y axis radius for rounded corners.
   */
  public RoundedRect( IRect rect, int rx, int ry )
  {
    setRoundedRect( rect, rx, ry );
  }
  /**
   * Create a copy of a rounded rect.
   * @param r rounded rect to copy.
   */
  public RoundedRect( RoundedRect r )
  {
    setRoundedRect( r );
  }
  
  public void setRoundedRect( IRect r, int radius )
  {
    setRoundedRect( r.getX(), r.getY(), r.getW(), r.getH(), radius, radius );
  }
  public void setRoundedRect( IRect r, int rx, int ry )
  {
    setRoundedRect( r.getX(), r.getY(), r.getW(), r.getH(), rx, ry );
  }  
  public void setRoundedRect( int x, int y, int w, int h, int radius )
  {
    setRoundedRect( x, y, w, h, radius, radius );
  }
  public void setRoundedRect( int x, int y, int w, int h, int rx, int ry )
  {
    x_=x; y_=y; w_=w; h_=h;
    rx_ = Math.min( w_/2, Math.abs(rx) );
    ry_ = Math.min( h_/2, Math.abs(ry) );
  }
  public void setRoundedRect( RoundedRect r )
  {
    x_=r.x_; y_=r.y_; w_=r.w_; h_=r.h_;
    rx_ = Math.min( w_/2, Math.abs(r.rx_) );
    ry_ = Math.min( h_/2, Math.abs(r.ry_) );
  }
  
  public int getX() { return x_; }
  public int getY() { return y_; }
  public int getW() { return w_; }
  public int getH() { return h_; }
  public int getRX() { return rx_; }
  public int getRY() { return ry_; }
  
  private class Data
  {
    int x1,y1,x2,y2;//bounds of rectangle
    int cx1,cy1,cx2,cy2; //center of ovals
    int rx,ry; //radius
    int type;
    Circle circle;
    Oval   oval;
    Segment segment;
    public Data( int x, int y, int w, int h, int rx, int ry )
    {
      this.rx=Math.abs(rx); this.ry=Math.abs(ry);
      x1=x; x2=x+w-1; if( x1>x2 ) { int t=x1; x1=x2; x2=t; }
      y1=y; y2=y+h-1; if( y1>y2 ) { int t=y1; y1=y2; y2=t; }
      int rrx = (x2-x1+1)/2;
      int rry = (y2-y1+1)/2;
      boolean tb_oval = (rrx<=rx);
      boolean lr_oval = (rry<=ry);
//TODO: missing type: rect only (rx==0 || ry==0)      
      if( tb_oval )
      {
        rx = rrx;
        if( lr_oval )
        {
          ry=rry;
          if( ry==rx ) type=10; //path is one a circle
          else type=20; //path is one oval
        } else {
          if( ry==rx ) {
            type=30;//path have top/down half circle
          } else {
            type=40;//path have top/down half oval
          }
        }
      } else {
        if( lr_oval )
        {
          ry=rry;
          if( rx==ry) {
            type=50; //path have left/right half circle
          } else {
            type=60; //path have left/right half oval
          }          
        } else {
          if( rx==0 || ry==0 )
          {
            type=1; //path is a simple rectangle
          } else if( rx==ry ) {
            type=70; //path have four circle at corners
          } else {
            type=80; //path have four oval at corners
          }
        }
      }
      cx1 = x1+rx; cx2 = x2-rx;
      cy1 = y1+ry; cy2 = y2-ry;
//System.out.println("RoundedRect.PathData: type="+type);      
    }
    
    /** brush must be started/ended by caller */
    public void fill( IGCDirect gc, IBrush brush )
    {
      switch(type)
      {
        default: case 0: return ;
        //shape is a simple rectangle:
        case 1: gc.fillRectDirect( x1,y1, x2-x1+1, y2-y1+1 ); break;
        //shape is one circle:
        case 10: CircleAlg.FillCircle( gc, cx1,cy1,rx ); break;
        //shape is one oval:
        case 20: OvalAlg.FillOval( gc, cx1, cy1, rx, ry ); break;
        //shape have top/down half circle or oval
        case 30:
        case 40:
        {
          OvalAlg ov = new OvalAlg( cx1,cy1, rx ,ry, 0,Radian._PI );
//TODO: replace by oval.fill for real ARC.          
          ov.fillOval( gc );
          gc.fillRectDirect( x1, cy1, x2-x1+1, cy2-cy1+1 );
          ov.setArc( cx2,cy2, rx,ry, Radian._PI, Radian._PI );
          ov.fillOval( gc );
          break;
        }
        //shape have left/right half oval:          
        case 50:
        case 60:
        {
          OvalAlg ov = new OvalAlg( cx1,cy1, rx ,ry, Radian._PI2,Radian._PI );
//TODO:replace by oval.fill          
          ov.fillOval( gc );
          gc.fillRectDirect( cx1, y1, cx2-cx1+1, y2-y1+1 );
          ov.setArc( cx2,cy2, rx,ry, Radian._3PI2, Radian._PI );
          ov.fillOval( gc );
          break;
        }
        //shape have four circle/ellipse at corner:
        case 70:
        {
          CircleAlg cl = new CircleAlg( cx1,cy1, rx_, Radian._3PI2, -Radian._PI2);
          CircleAlg cr = new CircleAlg( cx2,cy1, rx_, Radian._3PI2,  Radian._PI2);
          int yscan=y1;
          int xl = cx1, xr=cy1;
          do {
            while( cl.nextPoint(null) && cl.getY()<=yscan ) {
              int x=cl.getX(); if( x < xl ) xl=x;
            }
            while( cr.nextPoint(null) && cr.getY()<=yscan ) {
              int x=cr.getX(); if( x > xr ) xr=x;
            }
            gc.drawHLineDirect( xl, xr, yscan );
            yscan++;
            xl = cl.getX();
            xr = cr.getX();
          } while ( yscan < cy1 );
          //from cy1 to cy2 : this is a rectangle
          for( ; yscan<=cy2; yscan++ )
          {
            gc.drawHLineDirect( x1, x2, yscan );
          }
          cl.setArc( cx1, cy2, rx, Radian._PI, -Radian._PI2 );
          cr.setArc( cx2, cy2, rx, 0,           Radian._PI2 );
          xl=x1; xr=x2;
          boolean initl=true, initr=true;
          do
          {
            while( cl.nextPoint(null) && (cl.getY()<=yscan) ) {             
              int x=cl.getX(); if( x < xl ) xl=x;
            }            
            while( cr.nextPoint(null) && (cr.getY()<=yscan) ) {
              int x=cr.getX(); if( x > xr ) xr=x;
            }
            gc.drawHLineDirect( xl, xr, yscan );
            yscan++;
            xl = cl.getX();
            xr = cr.getX();
          } while ( yscan < y2 );
          gc.drawHLineDirect( cx1, cx2, y2 );
          break;
        }
        //shape have four circle at corner:  
        case 80:
        {
          OvalAlg cl = new OvalAlg( cx1,cy1, rx_,ry_, Radian._3PI2, -Radian._PI2);
          OvalAlg cr = new OvalAlg( cx2,cy1, rx_,ry_, Radian._3PI2,  Radian._PI2);
          int yscan=y1;
          int xl = cx1, xr=cy1;
          do {
            while( cl.nextPoint(null) && cl.getY()<=yscan ) {
              int x=cl.getX(); if( x < xl ) xl=x;
            }
            while( cr.nextPoint(null) && cr.getY()<=yscan ) {
              int x=cr.getX(); if( x > xr ) xr=x;
            }
            gc.drawHLineDirect( xl, xr, yscan );
            yscan++;
            xl = cl.getX();
            xr = cr.getX();
          } while ( yscan < cy1 );
          //from cy1 to cy2 : this is a rectangle
          for( ; yscan<=cy2; yscan++ )
          {
            gc.drawHLineDirect( x1, x2, yscan );
          }
          cl.setArc( cx1, cy2, rx,ry, Radian._PI, -Radian._PI2 );
          cr.setArc( cx2, cy2, rx,ry, 0,           Radian._PI2 );
          xl=x1; xr=x2;
          boolean initl=true, initr=true;
          do
          {
            while( cl.nextPoint(null) && (cl.getY()<=yscan) ) {             
              int x=cl.getX(); if( x < xl ) xl=x;
            }            
            while( cr.nextPoint(null) && (cr.getY()<=yscan) ) {
              int x=cr.getX(); if( x > xr ) xr=x;
            }
            gc.drawHLineDirect( xl, xr, yscan );
            yscan++;
            xl = cl.getX();
            xr = cr.getX();
          } while ( yscan < y2 );
          gc.drawHLineDirect( cx1, cx2, y2 );
          break;
        }
      }
    }
    
    public IPathElement nextPathElement()
    {      
      switch( type )
      {
        //no more path element to return
        default:
        case 0: return null;
        //path is a simple rectangle
        case 1:
          segment = new Segment( x1,y1, x2,y1 );
          type=2;
          return segment;
        case 2:
          segment.setLine( x2,y1+1, x2, y2-1 );
          type=3;
          return segment;
        case 3:
          segment.setLine( x2, y2, x1, y1 );
          type=4;
          return segment;
        case 4:
          segment.setLine( x1, y2-1, x1, y1+1 );
          type=0;
          return segment;
        //path is one circle  
        case 10: 
          circle = new Circle( cx1, cy1, rx ); 
          type=0;
          return circle;
        //path is one oval
        case 20: 
        {
          Oval oval = new Oval( cx1, cy1, rx, ry );
          type=0;
          return oval;
        }
        //path have top/bottom circle
        case 30: 
          circle = new Circle( cx1,cy1, rx, Radian._PI, Radian._PI );
          type=31;
          return circle;
        case 31:
          segment = new Segment( x2, cy1+1, x2, cy2-1 );
          type=32;
          return segment;
        case 32:
          circle.setArc( cx2,cy2, rx, 0, Radian._PI );
          type=33;
          return circle;
        case 33:
          segment.setLine( x1, cy2-1, x1, cy1+1 );
          type=0;
          return segment;
        //path have top/bottom oval
        case 40: 
          oval = new Oval( cx1,cy1, rx,ry, Radian._PI, Radian._PI );
          type=31;
          return oval;
        case 41:
//could be merged with 31 if type++ 
          segment = new Segment( x2, cy1+1, x2, cy2-1 );
          type=32;
          return segment;
        case 42:
          oval.setArc( cx2,cy2, rx,ry, 0, Radian._PI );
          type=33;
          return oval;
        case 43:
//could be merged with 33 if type++          
          segment.setLine( x1, cy2-1, x1, cy1+1 );
          type=0;
          return segment;
        //path have left/right circle
        case 50:
          segment = new Segment( cx1+1, y1, cx2-1, y1 );
          type=51;
          return segment;
        case 51:
          circle = new Circle( cx2,cy2, rx, Radian._3PI2, Radian._PI );
          type=52;
          return circle;
        case 52:
          segment = new Segment( cx2-1, y2, cx1+1, y2 );
          type=53;
          return segment;
        case 53:
          circle.setArc( cx1,cy1, rx, Radian._PI2, Radian._PI );
          type=0;
          return circle;
        //path have left/right oval
        case 60:
          segment = new Segment( cx1+1, y1, cx2-1, y1 );
          type=61;
          return segment;
        case 61:
          oval = new Oval( cx2,cy2, rx,ry, Radian._3PI2, Radian._PI );
          type=62;
          return oval;
        case 62:
          segment = new Segment( cx2-1, y2, cx1+1, y2 );
          type=63;
          return segment;
        case 63:
          oval.setArc( cx1,cy1, rx,ry, Radian._PI2, Radian._PI );
          type=0;
          return oval;
        //path is rounded rect using circle as corner:
        case 70:
          segment = new Segment( cx1,y1, cx2-1, y1 );
          type=71;
          return segment;
        case 71:
          circle = new Circle( cx2,cy1, rx, Radian._3PI2, Radian._PI2 );
          type=72;
          return circle;
        case 72:
          segment.setLine( x2, cy1, x2, cy2-1 );
          type=73;
          return segment;
        case 73:
          circle.setArc( cx2,cy2, rx, 0, Radian._PI2 );
          type=74;
          return circle;
        case 74:
          segment.setLine( cx2, y2, cx1+1, y2 );
          type=75;
          return segment;
        case 75:
          circle.setArc( cx1,cy2, rx, Radian._PI2, Radian._PI2 );
          type=76;
          return circle;
        case 76:
          segment.setLine( x1, cy2, x1, cy1+1 );
          type=77;
          return segment;
        case 77:
          circle.setArc( cx1,cy1, rx, Radian._PI, Radian._PI2 );
          type=0;
          return circle;
          
        //path is rounded rect using oval as corner:
        case 80:
          segment = new Segment( cx1,y1, cx2-1, y1 );
          type=81;
          return segment;
        case 81:
          oval = new Oval( cx2,cy1, rx,ry, Radian._3PI2, Radian._PI2 );
          type=82;
          return oval;
        case 82:
          segment.setLine( x2, cy1, x2, cy2-1 );
          type=83;
          return segment;
        case 83:
          oval.setArc( cx2,cy2, rx,ry, 0, Radian._PI2 );
          type=84;
          return oval;
        case 84:
          segment.setLine( cx2, y2, cx1+1, y2 );
          type=85;
          return segment;
        case 85:
          oval.setArc( cx1,cy2, rx,ry, Radian._PI2, Radian._PI2 );
          type=86;
          return oval;
        case 86:
          segment.setLine( x1, cy2, x1, cy1+1 );
          type=87;
          return segment;
        case 87:
          oval.setArc( cx1,cy1, rx,ry, Radian._PI, Radian._PI2 );
          type=0;
          return oval; 
      }
    }
  }
  protected Data data_;
    
  public boolean pathBegin(IGC gc, IGCDirect gd) 
  {
    if( gd.usePixelCoordinates() ) {
      data_ = new Data( x_,y_,w_,h_,rx_,ry_);
    } else {
      data_ = new Data( gd.devX(x_),gd.devY(y_),gd.devX(w_),gd.devY(h_),gd.devX(rx_),gd.devY(ry_));
    }
    return true;
  }

  public void pathEnd() 
  {
    data_=null;
  }

  public IPathElement nextPathElement() 
  {
    return data_.nextPathElement();
  }

  public IShape copyShape() { return new RoundedRect(this); }

  public boolean contains(int x, int y)
  {
    int xl = x_, xr = x_+w_-1, yt=y_, yb=y_+h_-1;
    if( w_<0 ) { xl=x_+w_-1; xr=x_; }
    if( h_<0 ) { yt=y_+h_-1; yb=y_; }
    if( x<xl || x>xr || y<yb || y > yt ) return false; //not in bounds
    if( rx_==0 || ry_==0 ) return true; //no rounded corner.
    int rrx = (xr-xl+1)/2, rry = (yt-yb+1)/2;
    if( rrx > rx_ ) rrx=rx_;
    if( rry > ry_ ) rry=ry_;
    int x1 = xl+rrx, x2 = xr-rrx;
    int corner_code=0;
    if( x < x1 ) corner_code =0x00;
    else if ( x <= x2 ) return true;
    else corner_code = 0x01;
    int y1 = yb+rry, y2 = yt-rry;
    if( y < y1 ) corner_code |= 0x10;
    else if ( y<= y2 ) return true;
    //still have to test for 4 corners...
    int cx=x1, cy=y2;
    switch( corner_code )
    {
      //case 0x00: cx=x1; xy=y2; break;
      case 0x01 : cy=y1; break;
      case 0x10 : cx=x2; break;
      case 0x11 : cx=x2; cy=y1; break;
    }
    int dx = x-cx, dy=y-cy;
    if( rx_==ry_ ) 
    {
      //for circle just check for radius:      
      double rp2 = dx*dx + dy*dy;
      double r2 = rx_*rx_;
      return rp2 <= r2;
    } else {
      //oval radius, but radius depends on points angle:
      double angle = Math.atan2( dy,dx);
      if( angle < 0 ) angle += Radian._2PI;
      double c = Math.cos(angle), s=Math.sin(angle);
      double rpx = rx_*c, rpy=ry_*s; 
      double ro2 = rpx*rpx+rpy*rpy; //oval radius at this angle
      double rp2 = dx*dx + dy*dy;
      return rp2 <= ro2;
    }
  }

  public boolean contains(IPoint p) {    
    return contains( p.getX(), p.getY() );
  }

  public IRect getBounds() { return new Rect( x_,y_,w_,h_);  }
  
  public boolean fillShape(IGC gc, IGCDirect gd, IBrush brush, IShape shape) 
  {
    if( !(shape instanceof RoundedRect) ) return false;
    
    if( rx_==0 || ry_==0 )
    {
      //rounded rect is simply a rectangle
      gc.fillRect( x_, y_, w_, h_ );
    }
    else
    {
      brush.brushBegin( gc, gd );
      if( gd.usePixelCoordinates() ) {
        data_ = new Data( x_,y_,w_,h_,rx_,ry_);
      } else {
        data_ = new Data( gd.devX(x_),gd.devY(y_),gd.devX(w_),gd.devY(h_),gd.devX(rx_),gd.devY(ry_));
      }      
      data_.fill( gd, brush );
      brush.brushEnd();
    }
    return true;
  }

  public void translate( int tx, int ty )
  {
    x_+=tx; 
    y_+=ty;
  }
}
