/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Segment.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IVector;


/**
 * Linear segment between two points.
 * This is also a IPath in order to be used in IGC.drawPath(), and others...
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Segment extends LineAlg implements IPath,IPathElement
{
  /** normalized tangent (no discontinuity in linear segment) */
  protected double tgx_, tgy_;
  
  public Segment( int x1, int y1, int x2, int y2 )
  {
    super(x1,y1,x2,y2);
  }
  public Segment( Segment s ) 
  {
    super(s.x1_,s.y1_,s.x2_,s.y2_);
  }
  public Segment()
  {
    super();
  }
  
  public IPathElement copyPathElement() { return new Segment(this); }
  
  public void setLine( int x1, int y1, int x2, int y2 )
  {
    super.setLine( x1, y1, x2, y2 );
    //compute normalized tangent once.
    tgx_ = x2-x1;
    tgy_ = y2-y1;    
    //normalize vector once.
    double n = Math.sqrt( tgx_*tgx_ + tgy_*tgy_ );
    if( n!=1.0 && n!=0.0 )
    {
      tgx_ /= n;
      tgy_ /= n;
    }
  }
  
  public boolean pathElementBegin(IGC gc, IGCDirect gd) {
    restart();
    return true;
  }

  public void pathElementEnd() {}

  public void backTangent(IVector vector) {
    vector.setVector( tgx_, tgy_ ); //already normalized.
  }

  public void frontTangent(IVector vector) {
    vector.setVector( tgx_, tgy_ ); //already normalized
  }

  public boolean pathBegin(IGC gc, IGCDirect gd) {
    restart();
    return true;
  }

  public void pathEnd() {}

  public IPathElement nextPathElement() { return state_==S_NOTSTARTED ? this : null; }
    
  
  /**
   * Translate both end points of rectangle. 
   * @param tx translation amount along X axis.
   * @param ty translation amount along Y axis.
   */
  public void translate( int tx, int ty )
  {
    x1_ += tx; x2_ += tx;
    y1_ += ty; y2_ += ty;
  }
  
}
