/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Size.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.internal.ISize;

/**
 * Implementation of a size.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Size implements ISize
{
  protected int width_, height_;
  
  public Size( int w, int h ) 
  {
    width_=w;
    height_=h;
  }
  public Size( ISize size )
  {
    width_=size.getW();
    height_=size.getH();
  }
  
  public int getW() { return width_; }
  public int getH() { return height_; }
  
  public void setW( int w ) { width_=w; }
  public void setH( int h ) { height_=h; }
  
  public void setSize( int w, int h ) { width_=w; height_=h; }
  public void setSize( ISize s ) { width_=s.getW(); height_=s.getH(); }

  public String toString()
  {
    return super.toString()+"{W="+width_+",H="+height_+"}";
  }
}
