/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SolidBrush.java,v 1.4 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;

/**
 * Solid brush implementation.
 * This brush return same RGBA color for each points.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SolidBrush implements IBrush
{
  protected int rgba_;
  
  /** Create brush using white solid color, use setRGBA() to change this color. */
  public SolidBrush()
  {
    rgba_ = RGBA.WHITE;
  }
  
  /** Create brush using solid color */
  public SolidBrush( int _rgba )
  {
    rgba_ = _rgba;
  }
  /** Create a copy of given brush */
  public SolidBrush( SolidBrush brush )
  {
    rgba_ = brush.rgba_;
  }
  
  public IBrush copyBrush()
  {
    return new SolidBrush( this );
  }
  
  /** @return current color of brush using RGBA encoding */
  public int getRGBA() { return rgba_; }
  
  /** Change current color of brush */
  public void setRGBA( int _rgba )
  {
    rgba_=_rgba;
  }
  
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IBrush#getBrushColor(int, int, int)
   */
  public int getBrushColor(int x, int y, int curr_rgba) 
  {
    return rgba_;
  }

  public void brushBegin( IGC gc, IGCDirect gd ) {}
  public void brushEnd() { }

  public void setBounds( int x, int y, int w, int h ) {}

    
  public String toString()
  {
    return super.toString()+"{rgba="+RGBA.Str(rgba_)+"}";
  }
}
