/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Spline.java,v 1.4 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.SplineAlg;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IVector;


/**
 * Spline is an abstract implementation of IPath and IPathElement for a 
 * spline curve.
 * @see Spline3 and Spline4
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public abstract class Spline implements IPath, IPathElement
{
  protected boolean hull_path_;
  
  public Spline()
  {    
  }
  
  /**
   * Change path generation, if true generate the hull path (segment between controls points),
   * otherwise generate spline path (default if false).
   */
  public void setHullPath( boolean b ) 
  {
    hull_path_ = b;
  }
  
  protected boolean give_path_element_;
  
  public boolean pathBegin(IGC gc, IGCDirect gd) 
  {
    give_path_element_ = true;
    return true;
  }
  
  public void pathEnd() {}
  
  public IPathElement nextPathElement() 
  {
    if( give_path_element_ )
    {
     give_path_element_=false;
      return this;
    }
    return null;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#pathElementEnd()
   */
  public void pathElementEnd() {}
  
  protected SplineAlg alg_ ;
  
  /** @return current X coordinate of point, available only is nextPoint() return true */  
  public int getX() { return alg_.getX(); }
  /** @return current Y coordinate of point, available only is nextPoint() return true */  
  public int getY() { return alg_.getY(); }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#nextPoint(org.eclipse.tptp.platform.report.igc.internal.IPoint)
   */
  public boolean nextPoint(IPoint point)
  {
    return alg_.nextPoint( point );
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#backTangent(org.eclipse.tptp.platform.report.igc.internal.IVector)
   */
  public void backTangent(IVector vector) 
  {
    alg_.backTangent( vector );     
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.igc.internal.IPathElement#frontTangent(org.eclipse.tptp.platform.report.igc.internal.IVector)
   */
  public void frontTangent(IVector vector) 
  {
    alg_.frontTangent( vector );
  }
}