/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Spline3.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.Spline3Alg;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;


/**
 * Spline3 is an implementation of IPath and IPathElement for a 
 * spline curve using 3 points as controls points.
 * Path pass through first and third points of spline (point A and C ).
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Spline3 extends Spline
{
  protected int xa_,ya_,xb_,yb_,xc_,yc_;
  
  /** 
   * Create a spline path or path element with 3 controls points (screen coordinates) 
   */
  public Spline3( int _xa,int _ya, int _xb,int _yb, int _xc,int _yc )
  {
    xa_=_xa; ya_=_ya;
    xb_=_xb; yb_=_yb;
    xc_=_xc; yc_=_yc;
  }
  /**
   * Create empty spline, use setPoints() to set controls points
   */
  public Spline3()
  {    
  }
  
  /** Change first control point of spline */
  public void setA( int _xa,int _ya )
  {
    if( xa_==_xa && ya_==_ya ) return ;
    xa_=_xa; ya_=_ya;
  }
  /** Change second control point of spline */
  public void setB( int _xb,int _yb )
  {
    if( xb_==_xb && yb_==_yb ) return ;
    xb_=_xb; yb_=_yb;
  }
  /** change third control point of spline */
  public void setC( int _xc,int _yc )
  {
    if( xc_==_xc && yc_==_yc ) return ;
    xc_=_xc; yc_=_yc;
  }
  /** Change all control points of spline */
  public void setPoints(  int _xa,int _ya, int _xb,int _yb, int _xc,int _yc )
  {
    xa_=_xa; ya_=_ya;
    xb_=_xb; yb_=_yb;
    xc_=_xc; yc_=_yc;
  }
  
  /** @return X Coordinate of first control point */
  public int getXA() { return xa_; }
  /** @return Y Coordinate of first control point */
  public int getYA() { return ya_; }
  /** @return X Coordinate of second control point */
  public int getXB() { return xb_; }
  /** @return Y Coordinate of second control point */
  public int getYB() { return yb_; }
  /** @return X Coordinate of third control point */
  public int getXC() { return xc_; }
  /** @return Y Coordinate of third control point */
  public int getYC() { return yc_; }
  
  public IPathElement copyPathElement() 
  {    
    return new Spline3( xa_,ya_,xb_,yb_,xc_,yc_);
  }
  
  public boolean pathElementBegin(IGC gc, IGCDirect gd) 
  {
    if( alg_==null) alg_=new Spline3Alg();
    if( gd.usePixelCoordinates() ) {
      ((Spline3Alg)alg_).setSpline( xa_,ya_, xb_,yb_, xc_,yc_ );
    } else {
      ((Spline3Alg)alg_).setSpline( gd.devX(xa_),gd.devY(ya_), gd.devX(xb_),gd.devY(yb_), gd.devX(xc_),gd.devY(yc_) );
    }
    alg_.setHullPath( hull_path_ );
    return true;
  }

}