/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SplineN.java,v 1.2 2008/05/23 14:11:54 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.SplineNAlg;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;


/**
 * SplineN is an implementation of IPath and IPathElement for a 
 * spline curve using N controls points.
 * Path pass through first and last points of spline.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SplineN extends Spline 
{
  protected IPolygon controls_;
  
  /** 
   * Create a spline path or path element with N controls points (screen coordinates) 
   */
  public SplineN( IPolygon _controls )
  {
    controls_=_controls;
  }
  /**
   * Create empty spline, use setControls() to set controls points
   */
  public SplineN()
  {    
  }
  
  /** @return control points polygon */
  public IPolygon getControls() { return controls_; }
  
  /** Change control points of spline */
  public void setControls( IPolygon _controls )
  {
    controls_=_controls;
  }
  
  public IPathElement copyPathElement() 
  {    
    return new SplineN( controls_==null ? null : new Polygon(controls_));
  }
  
  public boolean pathElementBegin(IGC gc, IGCDirect gd) 
  {
    if( controls_==null ) return false;
    if( alg_==null )  alg_ = new SplineNAlg();
    alg_.setHullPath( hull_path_ );
    if( gd.usePixelCoordinates() )
    {
      ((SplineNAlg)alg_).setSpline( controls_ );      
    } else {
      int size = controls_.getPolySize();
      Polygon dp = new Polygon( size );
      for( int i=0; i<size; i++ )
      {
        int x = controls_.getPolyX( i );
        int y = controls_.getPolyY( i );
        dp.setPoint( i, gd.devX(x), gd.devY(y) );
      }
      ((SplineNAlg)alg_).setSpline( dp );
    }
    return true;
  }
}