/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Vector.java,v 1.2 2008/05/23 14:11:55 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.internal.IVector;

/** 
 * Simple implementation of an IVector
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Vector implements IVector 
{
  protected double x_,y_,n_;
  public Vector() {}
  public Vector(double x, double y) { setVector(x,y); }
  public Vector(IVector v ) { setVector(v.getX(),v.getY()); }
  
  public double getX() { return x_; }
  public double getY() { return y_; }
  public void setX( double x ) { x_=x; }
  public void setY( double y ) { y_=y; }
  
  public void setVector( IVector p ) { setVector( p.getX(), p.getY()); }
  public void setVector( double x, double y ) 
  {
    x_=x; 
    y_=y;
    n_ = Math.sqrt(x_*x_ + y_*y_ );
  }
  
  public double getNorm() { return n_; }
  
  public void normalize()
  {
    if( n_!=1.0 )
    {
      if( n_!=0.0 )
      {
        x_ /= n_;
        y_ /= n_;
      }
      n_=1.0;
    }
  }
}
