/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DRenderRegistry.java,v 1.2 2008/05/23 14:11:53 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.render.internal;

import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.internal.*;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDRenderable;


/**
 * This class contains all registered Render to draw/locate IDRenderable objects,
 * including default renders for DGraphic and DDiagram.
 * Add your render using AddRender() method.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DRenderRegistry
{
  private static Vector other_renders_;
  private static DefaultChartRender _default_chart_render;
  
  /** 
   * @return a  render for given renderable object
   * returns null if no render is registried for this render type
   */
  public static IRender GetRender( IDRenderable _r ) 
  {
  	IRender render = null;
    if( other_renders_ != null )
    {
      for( int i=0; i<other_renders_.size(); ++i )
      {
        render =(IRender)other_renders_.get(i);
        if( render.canRender( _r) )
        {
          return render;
        }
      }
    }
    if (_r instanceof DGraphic)
    {
    	if (_default_chart_render==null) _default_chart_render = new DefaultChartRender();
        return _default_chart_render;
    }
    
    	
    return null;
  }
  
  /** 
   * Add a new render in this registry.
   */
  public static void AddRender( IRender _r )
  {
    if( other_renders_==null )
    {
      other_renders_ = new Vector(1);
    }
    other_renders_.add( _r );
  }
  
  /** 
   * Remove a render from this registry.
   * @return true if render is removed, false otherwise (render was not found or is a default one).
   */
  public static boolean RemoveRender( IRender _r )
  {
    if ( other_renders_==null) return false;
    return other_renders_.remove( _r );
  }

}
