/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRender.java,v 1.2 2008/05/23 14:11:53 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.render.internal;

import org.eclipse.tptp.platform.report.core.internal.IDRenderable;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IVObject;


/**
 * Interface to define a Render.
 * Render means paint a IRenderable or locate a point in this renderable.
 * A Render can provide draw/locate method for one or more kind of IRenderable.
 * To be available, a render must be registered in DRenderRegistry.
 * 
 * @see IRenderable, DRenderRegistry
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public interface IRender
{
  /**
   * Paint the given renderable on a rectangle using gc.
   * @param _gc the graphic context render use to draw.
   * @param _r  the rectangle where renderable must be drawn.
   * @param _scale a zoom scale applyed on renderable (1.0f for 100% scale)
   *               use this scale for text font size for example.
   * @param _ip image provider render can use to get images.
   * @param _monitor render is reponsible to call startElement/endElement of this interface. (can be null)
   * @param _data can be used by render to get/set private stuff, this for optimisation purpose
   * and object stored in data is under responsability of render, data can be null if caller
   * of draw doesn't provide persistence of this data.
   */
  public void draw( IGC _gc, IRect _r, 
  		            IDRenderable _g, float _scale, IDIImageProvider _ip, 
					IRenderMonitor _monitor,
					IVObject _data );

  /** 
   * Locate a point (_x,_y) in a renderable.
   * For parameters see draw method.
   * @see IRenderLocation
   */
  public IRenderLocation locate( int _x, int _y, IGC _gc, IRect _r, IDRenderable _g, float _scale, IDIImageProvider _ip, IVObject _data );
  
  /** 
   * Must return true if this render can handle (draw/locate) given renderable object, 
   * false otherwise
   */
  public boolean canRender( IDRenderable _r );
  
  /** 
   * Must return true if given renderable is known to support moving.
   * "moving" means graphic type knows how to handle DGraphic.P_PHI and .P_THETA properties.
   */
//TODO: remove this... as it's only for DGraphic 3D purpose...  
  //public  boolean canMoves( IDRenderable _r );  

}