/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRenderLocation.java,v 1.2 2008/05/23 14:11:53 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.render.internal;


import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IShape;


/**
 * Information about a location inside a IDRenderable.
 * An instance of this interface might be returned by method IRender#locate.
 * 
 * @see IDRenderable, IDRender
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public interface IRenderLocation
{
  /** @return id for the location, null if unknown, id must be provided by IRender, or IDRenderable */
  public String getId();
  /** @return item associated with this location */
  public IDItem getItem();
  /** @return area where the location is still valid */
  public IShape getArea();
}
