/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RenderableSnapShot.java,v 1.2 2008/05/23 14:11:53 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.render.internal;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTGC;
import org.eclipse.tptp.platform.report.render.internal.DRenderRegistry;
import org.eclipse.tptp.platform.report.render.internal.IRender;
import org.eclipse.tptp.platform.report.render.internal.NullRenderMonitor;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;


/**
 * Helper class if you want to take a picture of an IDRenderable item.
 * For example to save an image (@see org.eclipse.swt.graphics.ImageLoader)...
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class RenderableSnapShot
{
  /** 
   * This method take a picture of an IDRenderable item using existing IRender.
   * @return an Image where the graphic is rendered, caller is responsible to dispose
   * image resource.
   */
  public static Image Process( Device _dev, IRect _R, DGraphic _G, float _scale, IDIImageProvider ip )
  {
    Image offscreen = new Image( _dev, _R.getW(), _R.getH() );
    GC gc = new GC( offscreen );
    SWTGC igc = new SWTGC( _dev, gc );
    
    IRender render = DRenderRegistry.GetRender( _G );
    
    render.draw( igc, _R, _G, _scale, ip, new NullRenderMonitor(), null );

    gc.dispose();
    
    return offscreen;    
  }

}
