/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DisplayExecSignal.java,v 1.2 2008/05/23 14:12:07 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 4 juin 2003
 *
 */
package org.eclipse.tptp.platform.report.signals.internal;

import org.eclipse.swt.widgets.Display;

/**
 * This signal is emitted using Display.asyncExec or Display syncExec mecanism.
 * Signal's user is responsible to choose right emitXXX method to send signal.
 *
 * @see Display#asyncExec
 * @see Display#syncExec
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class DisplayExecSignal extends Signal
{
  protected Display default_display_ ;
  
  /**
   * Create a signal with not-yet-set default display
   * (set at emit time).
   */
  public DisplayExecSignal( String _name )
  {
    super(_name);
  }
  
  /**
   * Create a signal with a default display.
   */
  public DisplayExecSignal( Display _default_display, String _name )
  {
    super(_name);
    default_display_=_default_display;
  }
  
  /**
   * Emit signal using default display asyncExec method.
   * If default_display_ is not-yet-set fix it using Display.getDefault()
   * @see Display#asyncExec
   * @see Signal#emit
   * @param _parameters parameters of the signal
   */
  public void emitAsyncExec( Object []_parameters )
  {
    if( default_display_==null ) default_display_=Display.getDefault();
    
    emitAsyncExec( default_display_, _parameters );
  }
  
  /** 
   * Emit signal using provided display's asyncExec method
   * @see Display#asyncExec
   * @see Signal#emit
   * @param _parameters parameters of the signal
   */
  public void emitAsyncExec( Display _display, Object []_parameters )
  {   
    _display.asyncExec( new RunEmit( this, _parameters ) );   
  }

  /**
   * Emit signal using default display syncExec method.
   * If default_display_ is not-yet-set fix it using Display.getDefault()
   * @see Display#syncExec
   * @see Signal#emit
   * @param _parameters parameters of the signal
   */
  public void emitSyncExec( Object []_parameters )
  {
    if( default_display_==null ) default_display_=Display.getDefault();
    
    emitSyncExec( default_display_, _parameters );
  }
  
  /** 
   * Emit signal using provided display's syncExec method
   * @see Display#syncExec
   * @see Signal#emit
   * @param _parameters parameters of the signal
   */
  public void emitSyncExec( Display _display, Object []_parameters )
  {  
    _display.syncExec( new RunEmit( this, _parameters ) );   
  }
  
  /** Private usage only */
  private static class RunEmit implements Runnable
  {
    Signal signal_;
    Object params_[];
    public RunEmit(Signal _s, Object []_p)
    {
      signal_=_s; 
      params_=_p;
    }
    public void run()
    {
      signal_.emit( params_ );
    }
  }
  
}
