/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DisplaySyncExecSignal.java,v 1.2 2008/05/23 14:12:02 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 4 juin 2003
 *
 */
package org.eclipse.tptp.platform.report.signals.internal;

import org.eclipse.swt.widgets.Display;

/**
 * This signal is emitted using Display.syncExec mecanism.
 *
 * @see Display#syncExec
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class DisplaySyncExecSignal extends Signal
{
  protected Display default_display_ ;
  
  /**
   * Create a signal with not-yet-set default display
   * (set at emit time).
   */
  public DisplaySyncExecSignal( String _name )
  {
    super(_name);
  }
  
  /**
   * Create a signal with a default display.
   */
  public DisplaySyncExecSignal( Display _default_display, String _name )
  {
    super(_name);
    default_display_=_default_display;
  }
  
  /**
   * Emit signal using default display syncExec method.
   * If default_display_ is not-yet-set fix it using Display.getDefault()

   * @param _parameters parameters of the signal
   * @see Display#syncExec
   */
  public void emit( Object []_parameters )
  {
    if( default_display_==null ) default_display_=Display.getDefault();
    
    emit( default_display_, _parameters );
  }
  
  /** 
   * Emit signal using provided display's syncExec method
   * @see Display#syncExec
   * @param _parameters parameters of the signal
   */
  public void emit( Display _display, Object []_parameters )
  {
    _display.syncExec( new RunEmit( this, _parameters ) );
  }

  /** Private usage only */
  private static class RunEmit implements Runnable
  {
    Signal signal_;
    Object params_[];
    public RunEmit(Signal _s, Object []_p)
    {
      signal_=_s; 
      params_=_p;
    }
    public void run()
    {
      signal_.emitSignal( params_ );
    }
  }
  
}
