/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SWTConnectionFactory.java,v 1.2 2008/05/23 14:12:02 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.signals.internal;

import java.lang.reflect.Method;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

/**
 * This is a connection factory and a special connection definition for SWT Widget handling
 * in order to simplify the usage of Signal inside Widget, but also to ensure that  Signal
 * class haven't any SWT dependency (as Signal is used in AWT's chart viewer applet).
 * This class is loaded using Class.forName() by Signal class, if load works correctly
 * (class is found ...)  SWTConnectionFactory is used otherwise Signal.Connection is used
 * by default.
 * <P>
 * This class is used internally in signal package and must not be refered/used outside.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
class SWTConnectionFactory implements Signal.IConnectionFactory
{
  public Signal.Connection createConnection( Object _o, Method _m, String _method_sgn )
  {
    return new SWTConnection( _o, _m, _method_sgn );
  }
  
  /**
   * Add to Signal.Connection mechanism to handle Widget's dispose
   * (signal is disconnected automatically)
   */
  private static class SWTConnection extends Signal.Connection implements DisposeListener
  {
    public SWTConnection( Object _o, Method _m, String _method_sgn)
    {
      super( _o, _m, _method_sgn );
      
      //Swt's widget must not be called if they are disposed,
      //so keep in touch about this issue....
      if( _o instanceof Widget )
      {
        Widget w = (Widget)_o;
        if( w.isDisposed() )
        {
          //hmm?!! silly connect, widget is already disposed.
          r_receiver_.clear();
        } else {
          w.addDisposeListener( this );
        }
      }
    }
    public void widgetDisposed(DisposeEvent e)
    {
      if(r_receiver_!=null) r_receiver_.clear();
    }
  }
}