/* ***********************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SXPAttr.java,v 1.3 2009/05/06 12:01:03 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.sxp.internal;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

/**
 * Used in Simple Xml Parser.
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SXPAttr extends SXPNode implements Attr
{
  private String name_, value_;
  private boolean specified_;
  
  public SXPAttr( String name, String value )
  {
    name_=name;
    value_=value;
    specified_=value_!=null;
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#getNodeName()
   */
  public String getNodeName() { return name_; }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#getNodeValue()
   */
  public String getNodeValue() throws DOMException { return value_; }


  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#setNodeValue(java.lang.String)
   */
  public void setNodeValue(String nodeValue) throws DOMException 
  {
    value_=nodeValue;
    specified_=value_!=null;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#getNodeType()
   */
  public short getNodeType() { return Node.ATTRIBUTE_NODE; }


  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#hasAttributes()
   */
  public boolean hasAttributes() { return false; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Attr#getName()
   */
  public String getName() { return name_; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Attr#getSpecified()
   */
  public boolean getSpecified() {
    return specified_;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Attr#getValue()
   */
  public String getValue() { return value_; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Attr#setValue(java.lang.String)
   */
  public void setValue(String value) throws DOMException
  {
    value_=value;
    specified_=value_!=null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Attr#getOwnerElement()
   */
  public Element getOwnerElement() 
  {
    return (Element)parent_;
  }

  public TypeInfo getSchemaTypeInfo() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public boolean isId() {
	  // TODO Auto-generated method stub
	  return false;
  }

  public short compareDocumentPosition(Node other) throws DOMException {
	  // TODO Auto-generated method stub
	  return 0;
  }

  public String getBaseURI() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public Object getFeature(String feature, String version) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public String getTextContent() throws DOMException {
	  // TODO Auto-generated method stub
	  return null;
  }

  public Object getUserData(String key) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public boolean isDefaultNamespace(String namespaceUri) {
	  // TODO Auto-generated method stub
	  return false;
  }

  public boolean isEqualNode(Node arg) {
	  // TODO Auto-generated method stub
	  return false;
  }

  public boolean isSameNode(Node other) {
	  // TODO Auto-generated method stub
	  return false;
  }

  public String lookupNamespaceURI(String prefix) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public String lookupPrefix(String namespaceUri) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public void setTextContent(String textContent) throws DOMException {
	  // TODO Auto-generated method stub

  }

  public Object setUserData(String key, Object data, UserDataHandler handler) {
	  // TODO Auto-generated method stub
	  return null;
  }
}
