/* ***********************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SXPDocument.java,v 1.3 2009/05/06 12:01:03 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.sxp.internal;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

/**
 * Implementation of Document returned by SimpleXmlParser.
 * It store parsed document only, it can't be used to create XML document in any way.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SXPDocument extends SXPNode implements Document 
{  
  public DocumentType getDoctype() { return null; }

  public DOMImplementation getImplementation() { return null; }

  public Element getDocumentElement() 
  {
    for( SXPNode n=first_child_; n!=null; n=(SXPNode)n.getNextSibling())
    {
      if( n instanceof Element ) return (Element)n;
    }
    return null;
  }

  /** @return null */
  public Element createElement(String tagName) throws DOMException { return null; }
  /** @return null */
  public DocumentFragment createDocumentFragment() { return null; }
  /** @return null */
  public Text createTextNode(String data) { return null; }
  /** @return null */
  public Comment createComment(String data) { return null; }
  /** @return null */
  public CDATASection createCDATASection(String data) throws DOMException { return null ;}
  /** @return null */
  public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
    return null;
  }
  /** @return null */
  public Attr createAttribute(String name) throws DOMException { return null; }
  /** @return null */
  public EntityReference createEntityReference(String name) throws DOMException { return null; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Document#getElementsByTagName(java.lang.String)
   */
  public NodeList getElementsByTagName(String tagname)
  {
    int cnt=0;
    for( SXPNode n=first_child_; n!=null ;n=(SXPNode)n.getNextSibling() )
    {
      if( n instanceof Element && n.getNodeName().equals(tagname) )
      {
        cnt++;
      }
    }
    SXPNodeList nl = new SXPNodeList(cnt);
    for( SXPNode n=first_child_; n!=null ;n=(SXPNode)n.getNextSibling() )
    {
      if( n instanceof Element && n.getNodeName().equals(tagname) )
      {
        nl.addItem( n );
      }
    }
    return nl;
  }

  /** @return null */
  public Node importNode(Node importedNode, boolean deep) throws DOMException {
    return null;
  }

  /** @return null */
  public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
    return null;
  }

  /** @return null */
  public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
    return null;
  }

  /** @return null */
  public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Document#getElementById(java.lang.String)
   */
  public Element getElementById(String elementId) {
    //not supported
    return null;
  }

  /** @return "#document" */
  public String getNodeName() { return "#document"; }

  /** @return null */
  public String getNodeValue() throws DOMException {
    return null;
  }

  /** do nothing as document haven't node value */
  public void setNodeValue(String nodeValue) throws DOMException {}

  /** @return Node.DOCUMENT_NODE */
  public short getNodeType() { return Node.DOCUMENT_NODE; }

  /** @return this */
  public Document getOwnerDocument() { return this; }

  /** @return false */
  public boolean hasAttributes() { return false; }

  public Node adoptNode(Node source) throws DOMException {
	  // TODO Auto-generated method stub
	  return null;
  }

  public String getDocumentURI() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public DOMConfiguration getDomConfig() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public String getInputEncoding() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public boolean getStrictErrorChecking() {
	  // TODO Auto-generated method stub
	  return false;
  }

  public String getXmlEncoding() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public boolean getXmlStandalone() {
	  // TODO Auto-generated method stub
	  return false;
  }

  public String getXmlVersion() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public void normalizeDocument() {
	  // TODO Auto-generated method stub

  }

  public Node renameNode(Node n, String namespaceUri, String qualifiedName)
  throws DOMException {
	  // TODO Auto-generated method stub
	  return null;
  }

  public void setDocumentURI(String documentUri) {
	  // TODO Auto-generated method stub

  }

  public void setStrictErrorChecking(boolean strictErrorChecking) {
	  // TODO Auto-generated method stub

  }

  public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
	  // TODO Auto-generated method stub

  }

  public void setXmlVersion(String xmlVersion) throws DOMException {
	  // TODO Auto-generated method stub

  }

  public short compareDocumentPosition(Node other) throws DOMException {
	  // TODO Auto-generated method stub
	  return 0;
  }

  public String getBaseURI() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public Object getFeature(String feature, String version) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public String getTextContent() throws DOMException {
	  // TODO Auto-generated method stub
	  return null;
  }

  public Object getUserData(String key) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public boolean isDefaultNamespace(String namespaceUri) {
	  // TODO Auto-generated method stub
	  return false;
  }

  public boolean isEqualNode(Node arg) {
	  // TODO Auto-generated method stub
	  return false;
  }

  public boolean isSameNode(Node other) {
	  // TODO Auto-generated method stub
	  return false;
  }

  public String lookupNamespaceURI(String prefix) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public String lookupPrefix(String namespaceUri) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public void setTextContent(String textContent) throws DOMException {
	  // TODO Auto-generated method stub

  }

  public Object setUserData(String key, Object data, UserDataHandler handler) {
	  // TODO Auto-generated method stub
	  return null;
  }
}
