/* ***********************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SXPElement.java,v 1.3 2009/05/06 12:01:03 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.sxp.internal;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

/**
 * Element used by SimpleXmlParser.
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SXPElement extends SXPNode implements Element
{
  private String tag_name_;
  private NamedNodeMap attributes_;
  
  public SXPElement( String tag_name )
  {
    tag_name_=tag_name;
    attributes_ = new SXPNamedNodeMap();
  }
  
  
  public NamedNodeMap getAttributes()
  {
    return attributes_;
  }
  
  /* (non-Javadoc)
   * @see org.w3c.dom.Element#getTagName()
   */
  public String getTagName() { return tag_name_; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#getAttribute(java.lang.String)
   */
  public String getAttribute(String name) 
  {
    return ((Attr)attributes_.getNamedItem( name )).getValue();
  }  

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#setAttribute(java.lang.String, java.lang.String)
   */
  public void setAttribute(String name, String value) throws DOMException 
  {
    attributes_.setNamedItem( new SXPAttr(name,value) );    
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#removeAttribute(java.lang.String)
   */
  public void removeAttribute(String name) throws DOMException 
  {
    attributes_.removeNamedItem( name );    
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#getAttributeNode(java.lang.String)
   */
  public Attr getAttributeNode(String name) {
    return (Attr)attributes_.getNamedItem( name );
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#setAttributeNode(org.w3c.dom.Attr)
   */
  public Attr setAttributeNode(Attr newAttr) throws DOMException {
    attributes_.setNamedItem( newAttr );
    return newAttr;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#removeAttributeNode(org.w3c.dom.Attr)
   */
  public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
    if( oldAttr.getParentNode()!=this ) return null;
    attributes_.removeNamedItem( oldAttr.getName() );
    SXPNode n = (SXPNode)oldAttr;
    n.setParent(null);
    return oldAttr;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#getNodeName()
   */
  public String getNodeName() {
    return tag_name_;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#getNodeValue()
   */
  public String getNodeValue() throws DOMException {
    return null;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#setNodeValue(java.lang.String)
   */
  public void setNodeValue(String nodeValue) throws DOMException {}

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#getNodeType()
   */
  public short getNodeType() {
    return Node.ELEMENT_NODE;
  }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#hasAttributes()
   */
  public boolean hasAttributes() {
    return attributes_.getLength() != 0;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#getElementsByTagName(java.lang.String)
   */
  public NodeList getElementsByTagName(String name)
  {
    int cnt=0;
    for( SXPNode n=first_child_; n!=null; n=(SXPNode)n.getNextSibling() )
    {
      if( n.getNodeType() == Node.ELEMENT_NODE && n.getNodeName().equals(name) )
      {
        cnt++;
      }
    }
    SXPNodeList nl = new SXPNodeList(cnt);
    for( SXPNode n=first_child_; n!=null; n=(SXPNode)n.getNextSibling() )
    {
      if( n.getNodeType() == Node.ELEMENT_NODE && n.getNodeName().equals(name) )
      {
        nl.addItem( n );
      }
    }
    return nl;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#getAttributeNS(java.lang.String, java.lang.String)
   */
  public String getAttributeNS(String namespaceURI, String localName) 
  {
    //not supported
   /* Node n= attributes_.getNamedItemNS( namespaceURI, localName );
    if( n==null ) return null;
    return ((Attr)n).getValue();*/
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#setAttributeNS(java.lang.String, java.lang.String, java.lang.String)
   */
  public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
    //not supported 
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#removeAttributeNS(java.lang.String, java.lang.String)
   */
  public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
    //not supported    
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#getAttributeNodeNS(java.lang.String, java.lang.String)
   */
  public Attr getAttributeNodeNS(String namespaceURI, String localName) {
    // not supported
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#setAttributeNodeNS(org.w3c.dom.Attr)
   */
  public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
    //not supported
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#getElementsByTagNameNS(java.lang.String, java.lang.String)
   */
  public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
    //not supported
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#hasAttribute(java.lang.String)
   */
  public boolean hasAttribute(String name) {
    // TODO Auto-generated method stub
    Node n = attributes_.getNamedItem(name);
    return n!=null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Element#hasAttributeNS(java.lang.String, java.lang.String)
   */
  public boolean hasAttributeNS(String namespaceURI, String localName) {
    //not supported
    return false;
  }

  public TypeInfo getSchemaTypeInfo() {
	  // TODO Auto-generated method stub
	  return null;
  }


  public void setIdAttribute(String name, boolean isId) throws DOMException {
	  // TODO Auto-generated method stub

  }


  public void setIdAttributeNS(String namespaceUri, String localName, boolean isId)
  throws DOMException {
	  // TODO Auto-generated method stub

  }


  public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
	  // TODO Auto-generated method stub

  }


  public short compareDocumentPosition(Node other) throws DOMException {
	  // TODO Auto-generated method stub
	  return 0;
  }


  public String getBaseURI() {
	  // TODO Auto-generated method stub
	  return null;
  }


  public Object getFeature(String feature, String version) {
	  // TODO Auto-generated method stub
	  return null;
  }


  public String getTextContent() throws DOMException {
	  // TODO Auto-generated method stub
	  return null;
  }


  public Object getUserData(String key) {
	  // TODO Auto-generated method stub
	  return null;
  }


  public boolean isDefaultNamespace(String namespaceUri) {
	  // TODO Auto-generated method stub
	  return false;
  }


  public boolean isEqualNode(Node arg) {
	  // TODO Auto-generated method stub
	  return false;
  }


  public boolean isSameNode(Node other) {
	  // TODO Auto-generated method stub
	  return false;
  }


  public String lookupNamespaceURI(String prefix) {
	  // TODO Auto-generated method stub
	  return null;
  }


  public String lookupPrefix(String namespaceUri) {
	  // TODO Auto-generated method stub
	  return null;
  }


  public void setTextContent(String textContent) throws DOMException {
	  // TODO Auto-generated method stub

  }


  public Object setUserData(String key, Object data, UserDataHandler handler) {
	  // TODO Auto-generated method stub
	  return null;
  }
}
