/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SXPNamedNodeMap.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.sxp.internal;

import java.util.HashMap;
import java.util.Map;

import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/**
 * Used by Simple Xml Parser (SXPElement)
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SXPNamedNodeMap implements NamedNodeMap
{
  protected HashMap map_;
  
  public SXPNamedNodeMap()
  {
    map_ = new HashMap();
  }
  
  /* (non-Javadoc)
   * @see org.w3c.dom.NamedNodeMap#getNamedItem(java.lang.String)
   */
  public Node getNamedItem(String name)
  {
    return (Node)map_.get( name );
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.NamedNodeMap#setNamedItem(org.w3c.dom.Node)
   */
  public Node setNamedItem(Node arg) throws DOMException {
    map_.put( arg.getNodeName(), arg );
    return arg;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.NamedNodeMap#removeNamedItem(java.lang.String)
   */
  public Node removeNamedItem(String name) throws DOMException 
  {
    Node n = (Node)map_.get( name );      
    if( n!=null )
    {
      map_.remove( name );
    }
    return n;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.NamedNodeMap#item(int)
   */
  public Node item(int index) 
  {
    Object o[] = map_.entrySet().toArray();
    return (Node)((Map.Entry)o[index]).getValue();
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.NamedNodeMap#getLength()
   */
  public int getLength() {
    return map_.size();
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.NamedNodeMap#getNamedItemNS(java.lang.String, java.lang.String)
   */
  public Node getNamedItemNS(String namespaceURI, String localName) {
    //not supported
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.NamedNodeMap#setNamedItemNS(org.w3c.dom.Node)
   */
  public Node setNamedItemNS(Node arg) throws DOMException {
    // not supported
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.NamedNodeMap#removeNamedItemNS(java.lang.String, java.lang.String)
   */
  public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
    // not supported
    return null;
  }

}
