/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SXPNode.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.sxp.internal;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Used by SimpleXmlParser.
 * Abstract implementation of Node, handle parent, sibling and children.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class SXPNode implements Node
{
  protected SXPNode parent_, prev_, next_, first_child_, last_child_;
  
  public void setParent( SXPNode p ) { parent_=p; }
  public void setPrev( SXPNode p ) { prev_=p; }
  public void setNext( SXPNode p ) { next_=p; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getNodeName()
   */
  public abstract String getNodeName();

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getNodeValue()
   */
  public abstract String getNodeValue() throws DOMException;

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#setNodeValue(java.lang.String)
   */
  public abstract void setNodeValue(String nodeValue) throws DOMException ;

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getNodeType()
   */
  public abstract short getNodeType() ;

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getParentNode()
   */
  public Node getParentNode() { return parent_; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getChildNodes()
   */
  public NodeList getChildNodes() 
  {
    int cnt=0;
    for( Node c=first_child_; c!=null; c=c.getNextSibling() ) cnt++; 
    SXPNodeList nl = new SXPNodeList( cnt );
    for( Node c=first_child_; c!=null; c=c.getNextSibling() ) nl.addItem( c);  
    return nl;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getFirstChild()
   */
  public Node getFirstChild() { return first_child_; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getLastChild()
   */
  public Node getLastChild() { return last_child_; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getPreviousSibling()
   */
  public Node getPreviousSibling() { return prev_; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getNextSibling()
   */
  public Node getNextSibling() { return next_; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getAttributes()
   */
  public NamedNodeMap getAttributes() { return null; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getOwnerDocument()
   */
  public Document getOwnerDocument() {
    return parent_!=null ? parent_.getOwnerDocument() : null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#insertBefore(org.w3c.dom.Node, org.w3c.dom.Node)
   */
  public Node insertBefore(Node newChild, Node refChild) throws DOMException
  {
    SXPNode new_child = (SXPNode)newChild;
    //remove newChild :
    if( new_child.getParentNode()!=null )
    {
      new_child.getParentNode().removeChild( new_child );
    }
    else
    {
      if( new_child.getPreviousSibling()!=null ) 
      {
        ((SXPNode)new_child.getPreviousSibling()).setNext( (SXPNode)new_child.getNextSibling() );
      }
      if( new_child.getNextSibling()!=null )
      {
        ((SXPNode)new_child.getNextSibling()).setPrev( (SXPNode)new_child.getPreviousSibling() );
      }
      new_child.setParent( null );
    }
    
    if( refChild==null )
    {
      if( last_child_==null )
      {
        first_child_=last_child_=new_child; 
      } else {
        new_child.setPrev( last_child_ );
        last_child_.setNext( new_child );
        last_child_ = new_child ;        
      }
    }
    else
    {
      for( SXPNode c=first_child_; c!=null; c=(SXPNode)c.getNextSibling() )
      {
        if( c==refChild )
        {
          new_child.setNext( c);
          c.setPrev( new_child );
          if( c==first_child_) first_child_=new_child;
          new_child.setParent( this );
          return new_child;
        }
      }
      //TODO: DOMException refChild not found.
      return null;
    }
    new_child.setParent( this );
    return new_child;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#replaceChild(org.w3c.dom.Node, org.w3c.dom.Node)
   */
  public Node replaceChild(Node newChild, Node oldChild) throws DOMException
  {
    SXPNode new_child = (SXPNode)newChild;
    SXPNode old_child = (SXPNode)oldChild;
    for( SXPNode n=first_child_; n!=null; n=(SXPNode)n.getNextSibling())
    {
      if( n==old_child )
      {
        SXPNode p = (SXPNode)old_child.getPreviousSibling();
        new_child.setPrev( p );
        if( p!=null ) p.setNext( new_child );
        p = (SXPNode)old_child.getNextSibling();
        new_child.setNext( p );
        if(p!=null) p.setPrev( new_child );
        new_child.setParent( this );
        //remove old:
        old_child.setPrev( null );
        old_child.setNext( null );
        old_child.setParent( null );
        if( first_child_==old_child ) first_child_=new_child;
        if( last_child_ ==old_child ) last_child_ =new_child;
        return old_child;
      }
    }
    //TODO: DOMException oldChild not found
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#removeChild(org.w3c.dom.Node)
   */
  public Node removeChild(Node oldChild) throws DOMException 
  {
    if( oldChild.getParentNode() != this ) 
    {
      //TODO/ DOMException:NOT_FOUND_ERR
      return null;
    } else {
      SXPNode old = (SXPNode)oldChild;
      old.setParent( null );
      if( old==first_child_ ) first_child_=(SXPNode)first_child_.getNextSibling();
      if( old==last_child_  ) last_child_ =(SXPNode)last_child_ .getPreviousSibling();
      old.setPrev( null );
      old.setNext( null );
      return old;
    }
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#appendChild(org.w3c.dom.Node)
   */
  public Node appendChild(Node newChild) throws DOMException
  {
    SXPNode n = (SXPNode)newChild;
    if( n.getParentNode()!=null )
    {
      n.getParentNode().removeChild( newChild );
    }
    if( last_child_==null )
    {
      first_child_ = last_child_ = n;   
      n.setPrev( null );
      n.setNext( null );
    } else {
      last_child_.setNext( n ) ;
      n.setPrev( last_child_ );
      n.setNext( null );
      last_child_=n;
    }
    n.setParent( this );
    return n;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#hasChildNodes()
   */
  public boolean hasChildNodes() {
    return first_child_!=null ;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#cloneNode(boolean)
   */
  public Node cloneNode(boolean deep) {
    //not supported
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#normalize()
   */
  public void normalize() {
    //not supported    
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#isSupported(java.lang.String, java.lang.String)
   */
  public boolean isSupported(String feature, String version) {
    return false;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getNamespaceURI()
   */
  public String getNamespaceURI() {
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getPrefix()
   */
  public String getPrefix() {
    //not supported
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#setPrefix(java.lang.String)
   */
  public void setPrefix(String prefix) throws DOMException {
    // not supported
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#getLocalName()
   */
  public String getLocalName() {
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.Node#hasAttributes()
   */
  public abstract boolean hasAttributes();

  
  public final void dump()
  {
    dump("");
  }
  protected void dump(String indent)
  {
    System.out.print(indent+"Node["+getNodeName()+"] value='"+getNodeValue()+"'");
    if( this instanceof Element )
    {
      Element e=(Element)this;
      NamedNodeMap attr = e.getAttributes();
      if( attr!=null)
      for( int i=0; i<attr.getLength(); ++i)
      {
        Attr a = (Attr)attr.item(i);
        System.out.print(" "+a.getName()+"=\""+a.getValue()+"\"");
      }
    }
    if( hasChildNodes() )
    {
      System.out.print(" children={");
      System.out.println();
      ((SXPNode)getFirstChild()).dump(indent+"  ");
      System.out.println(indent+"}");
    } else {
          System.out.println(" children={}");
    }
    if( next_!=null )
    {
      next_.dump(indent);
    }
  }
}
