/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SXPNodeList.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.sxp.internal;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Used in SimpleXmlParser and associates.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SXPNodeList implements NodeList
{
  private Node nodes_[];
  private int count_;
  
  public SXPNodeList( int size )
  {
     nodes_ = new Node[size];
     count_=0;
  }
  
  public void setItem( int index, Node item )
  {
    nodes_[index]=item;
  }
  
  public void addItem( Node item )
  {
    nodes_[count_++] = item;
  }
  
  /* (non-Javadoc)
   * @see org.w3c.dom.NodeList#item(int)
   */
  public Node item(int index) 
  {
    if( nodes_==null ) return null;    
    return nodes_[index];
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.NodeList#getLength()
   */
  public int getLength() { return count_; }

}
