/* ***********************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SXPText.java,v 1.3 2009/05/06 12:01:03 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.sxp.internal;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

/**
 * Used by Simple Xml Parser
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SXPText extends SXPNode implements Text
{
  protected String text_;
  
  public SXPText( String t ) 
  {
    text_=t;
  }
  
  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#getNodeName()
   */
  public String getNodeName() { return "#text"; }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#getNodeValue()
   */
  public String getNodeValue() throws DOMException { return text_; }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#setNodeValue(java.lang.String)
   */
  public void setNodeValue(String nodeValue) throws DOMException { text_=nodeValue; }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#getNodeType()
   */
  public short getNodeType() { return Node.TEXT_NODE; }

  /* (non-Javadoc)
   * @see org.eclipse.tptp.platform.report.chart.internal.SXPNode#hasAttributes()
   */
  public boolean hasAttributes() { return false; }

  /* (non-Javadoc)
   * @see org.w3c.dom.Text#splitText(int)
   */
  public Text splitText(int offset) throws DOMException 
  {
    //not supported
    return null;
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.CharacterData#getData()
   */
  public String getData() throws DOMException { return text_; }

  /* (non-Javadoc)
   * @see org.w3c.dom.CharacterData#setData(java.lang.String)
   */
  public void setData(String data) throws DOMException { text_=data; }

  /* (non-Javadoc)
   * @see org.w3c.dom.CharacterData#getLength()
   */
  public int getLength() { return text_==null ? 0 : text_.length(); }

  /* (non-Javadoc)
   * @see org.w3c.dom.CharacterData#substringData(int, int)
   */
  public String substringData(int offset, int count) throws DOMException 
  {
    if( text_==null ) return null;
    return text_.substring( offset, offset+count );
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.CharacterData#appendData(java.lang.String)
   */
  public void appendData(String arg) throws DOMException 
  {
    if( text_==null ) text_=arg; else text_+=arg;    
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.CharacterData#insertData(int, java.lang.String)
   */
  public void insertData(int offset, String arg) throws DOMException 
  {
    if( text_ == null ) text_=arg;
    else {
      text_ = text_.substring( 0, offset ) + arg + text_.substring( offset );
    }
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.CharacterData#deleteData(int, int)
   */
  public void deleteData(int offset, int count) throws DOMException
  {
    if( text_==null ) return ;
    text_ = text_.substring( 0, offset ) + text_.substring( offset+count );    
  }

  /* (non-Javadoc)
   * @see org.w3c.dom.CharacterData#replaceData(int, int, java.lang.String)
   */
  public void replaceData(int offset, int count, String arg) throws DOMException 
  {
    if( text_==null ) text_ = arg;
    else {
      text_ = text_.substring( 0, offset ) + arg + text_.substring( offset+count );
    }
  }

  public String getWholeText() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public boolean isElementContentWhitespace() {
	  // TODO Auto-generated method stub
	  return false;
  }

  public Text replaceWholeText(String arg0) throws DOMException {
	  // TODO Auto-generated method stub
	  return null;
  }

  public short compareDocumentPosition(Node other) throws DOMException {
	  // TODO Auto-generated method stub
	  return 0;
  }

  public String getBaseURI() {
	  // TODO Auto-generated method stub
	  return null;
  }

  public Object getFeature(String feature, String version) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public String getTextContent() throws DOMException {
	  // TODO Auto-generated method stub
	  return null;
  }

  public Object getUserData(String key) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public boolean isDefaultNamespace(String namespaceUri) {
	  // TODO Auto-generated method stub
	  return false;
  }

  public boolean isEqualNode(Node arg) {
	  // TODO Auto-generated method stub
	  return false;
  }

  public boolean isSameNode(Node other) {
	  // TODO Auto-generated method stub
	  return false;
  }

  public String lookupNamespaceURI(String prefix) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public String lookupPrefix(String namespaceUri) {
	  // TODO Auto-generated method stub
	  return null;
  }

  public void setTextContent(String textContent) throws DOMException {
	  // TODO Auto-generated method stub

  }

  public Object setUserData(String key, Object data, UserDataHandler handler) {
	  // TODO Auto-generated method stub
	  return null;
  }
}
