/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AWTIImageProvider.java,v 1.4 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.tools.internal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;

import org.eclipse.tptp.platform.report.igc.awt.internal.AWTImage;
import org.eclipse.tptp.platform.report.igc.internal.IImage;


/**
 * Implementation of IDIImageProvider for AWT graphic system.
 * IImage returned are org.eclipse.tptp.platform.report.igc.internal.awt.AWTImage object.
 * It uses monitored ImageObserver to wait image loading before returning image.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class AWTIImageProvider extends AbstractIImageProvider
{
  /**
    * Create a new image provider operating using specified device.<br>
    * Do not forget to call <b>dispose()</b> when this object is no longer used.<br>
    * <b>Note:</b> As IImage must use pixel coordinates measure, device must be a Display.
    */
   public AWTIImageProvider() {}
   
   protected IImage createBrokenImage()
   {
     try {
       ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
       BufferedInputStream bis = new BufferedInputStream( 
            IDIImageProvider.class.getResourceAsStream("brokenImage.gif") );
       int l;
       byte buf[] = new byte[4096];
       while( (l=bis.read(buf))>0 )
       {
         bos.write( buf, 0, l );     
       }
       Image image = Toolkit.getDefaultToolkit().createImage( bos.toByteArray() );
       if( waitLoadImage( image ) )
         return new AWTImage( image, (ImageObserver)null );      
     } catch (Throwable t) {
        System.err.println("Cannot load image brokenImage.gif");
     }
     
     BufferedImage bi = new BufferedImage( 30, 30, BufferedImage.TYPE_INT_RGB );
     Graphics g = bi.getGraphics();
     g.setColor( new Color(255,0,0));
     g.fillRect( 0,0,30,30);
     return new AWTImage( bi, (ImageObserver)null );
   }
   

   /**
    * Change current broken image, disposing current one before. After this call broken imag
    * is under the control of image provider, do not dispose it, image provide will do.
    */
   public void setBrokenImage(IImage image)
   {
     if( brokenImage instanceof AWTImage ) ((AWTImage)brokenImage).disposeImage();
     brokenImage = image;
   }

   protected IImage createImageFromFile( String filename )
   {
     if( filename==null ) return null;
     File f = new File( filename );
     if( !f.exists() )
     {
       return null;
     }
     Image img=null;
     try {
       img =Toolkit.getDefaultToolkit().createImage(filename);
       if( waitLoadImage( img ) )
         return new AWTImage( img, (ImageObserver)null );
     } catch( Throwable t ) {
       return null;
     }
     return null;
   }
   
   protected IImage createImageFromInputStream( InputStream input_stream )
   {
     if( input_stream==null ) return null;
     Image img=null;
     try {
       ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
       BufferedInputStream bis = new BufferedInputStream(  input_stream );
            
       int l;
       byte buf[] = new byte[4096];
       while( (l=bis.read(buf))>0 )
       {
         bos.write( buf, 0, l );         
       }
       img = Toolkit.getDefaultToolkit().createImage( bos.toByteArray() ); 
       if( waitLoadImage( img ) )
         return new AWTImage( img, (ImageObserver)null );
     } catch( Throwable t ) {
       return null;
     }
     return null;
   }
  
   protected void disposeImage( IImage image )
   {
     if( image instanceof AWTImage )
     {
       ((AWTImage)image).disposeImage();
     }
   } 
   
   private boolean waitLoadImage( Image img )
   {
     Toolkit tk = Toolkit.getDefaultToolkit();
     if( tk.prepareImage( img, -1, -1, null ) ) return true;//already fully prepared
     //image is being loading by toolkit in a separate thread...
     for(;;)
     {
       int st=tk.checkImage( img, -1, -1, null );
       if( (st&ImageObserver.ERROR  )!=0 ) return false;
       if( (st&ImageObserver.ALLBITS)!=0 ) return true ;
       if( (st&ImageObserver.ABORT  )!=0 )  return false;
       try {
         Thread.sleep(50);
       }
       catch (InterruptedException e) {}
     }
   }

}
 
   