/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CalendarField.java,v 1.4 2008/12/15 15:34:35 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 8 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.IDStringSerializable;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IDXmlSerializable;
import org.w3c.dom.Node;

import com.ibm.icu.util.Calendar;


/**
 * CalendarField designed to hold one or more fields of a com.ibm.icu.util.Calendar as the
 * user set() them. One difference from Calendar is com.ibm.icu.util.Calendar complete a date using
 * default fields values, CalendarField Doesn't.
 * This class was designed for step purpose in DAxis object using Date, but  if it's
 * suitable for you feel free to use it.
 * 
 * @see com.ibm.icu.util.Calendar
 * @see org.eclipse.tptp.platform.report.core.internal.DAxis
 * @author ademuyser
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class CalendarField implements IDXmlSerializable, IDStringSerializable
{
  /** current value of possible field */
  Calendar calendar = Calendar.getInstance();
  private int     fields_[] = new int    [calendar.getFieldCount()];
  private boolean set_   [] = new boolean[calendar.getFieldCount()];
 
  /**
   * Create a CalendarField, all fields unset with undefined values.
   * Fields can be setset(), or unset().  Check is a field have been set
   * using isSet().  Retrieve value using get()
   */
  public CalendarField() 
  {
    reset();
  }
  
  /**
   * Create a CalendarField and set value for one of them.
   * Equivalent to  (new CalendarField()).set( _field, _value)
   */
  public CalendarField( int _field, int _value )
  {
    reset();
    set( _field, _value );
  }
  
  /**
   * Reset all previously fields set.
   */
  public void reset()
  {
    for( int i=0; i<fields_.length; ++i ) set_[i]=false;
  }
  
  /**
   * Change value of a fied.
   * @param _field one of field constant defined in com.ibm.icu.util.Calendar.
   * @param _value new value of field, for correct value range report to com.ibm.icu.util.Calendar.
   * @see com.ibm.icu.util.Calendar
   */
  public void set( int _field, int _value )
  {  
    fields_[_field] = _value;
    set_[_field] = true;
  }
  
  /**
   * Return current value of a field.
   * @param _field one of field constant defined in com.ibm.icu.util.Calendar.
   * @return current field value, or undefined value if field haven't been set before.
   */
  public int get( int _field )
  {
    return fields_[_field] ;
  }

  /**
   * Check is a field have been set.
   * @param _field one of field constant defined in com.ibm.icu.util.Calendar.
   * @return true if value set, false otherwise.
   */  
  public boolean isSet( int _field )
  {
    return set_[_field];
  }
  
  /**
   * Unset field value.
   * @param _field one of field constant defined in com.ibm.icu.util.Calendar.
   */
  public void unset( int _field )
  {
    set_[_field] = false;
  }
  
  /**
   * @deprecated prefer use getFieldName
   * For debug purpose, return the Calendar field name from field value,
   * or number converted to string, if field isn't known.
   * @param _field one of constant defined in com.ibm.icu.util.Calendar
   * @return name or value of field. 
   */
  public static String FieldName( int _field )
  {
    if( _field == Calendar.YEAR ) return "YEAR";  
    if( _field == Calendar.MONTH ) return "MONTH";  
    if( _field == Calendar.DST_OFFSET ) return "DST_OFFSET";  
    if( _field == Calendar.DAY_OF_MONTH ) return "DAY_OF_MONTH";  
    if( _field == Calendar.MILLISECOND ) return "MILLISECOND";  
    if( _field == Calendar.SECOND ) return "SECOND";  
    if( _field == Calendar.DAY_OF_WEEK_IN_MONTH ) return "DAY_OF_WEEK_IN_MONTHDAY";  
    if( _field == Calendar.DAY_OF_YEAR ) return "DAY_OF_YEAR";  
    if( _field == Calendar.DAY_OF_WEEK ) return "DAY_OF_WEEK";  
    if( _field == Calendar.ERA ) return "ERA";  
    if( _field == Calendar.AM_PM ) return "AM_PM";  
    if( _field == Calendar.HOUR ) return "HOUR";  
    if( _field == Calendar.HOUR_OF_DAY ) return "HOUR_OF_DAY";  
    if( _field == Calendar.WEEK_OF_MONTH ) return "WEEK_OF_MONTH";  
    if( _field == Calendar.WEEK_OF_YEAR ) return "WEEK_OF_YEAR";  
    if( _field == Calendar.ZONE_OFFSET ) return "ZONE_OFFSET";  
    return Integer.toString(_field);
  }
  
  /**
   * @return the Calendar field name from field value,
   * or number converted to string, if field isn't known.
   * @param _field one of constant defined in com.ibm.icu.util.Calendar 
   * the value are:
   * <pre>
   *  Calendar.YEAR                    => year  
   *  Calendar.MONTH                   => month  
   *  Calendar.DST_OFFSET              => dst_offset 
   *  Calendar.DAY_OF_MONTH            => day of month
   *  Calendar.MILLISECOND             => ms
   *  Calendar.SECOND                  => s  
   *  Calendar.DAY_OF_WEEK_IN_MONTH    => day of week in monthday  
   *  Calendar.DAY_OF_YEAR             => day of year  
   *  Calendar.DAY_OF_WEEK             => day of week  
   *  Calendar.ERA                     => era  
   *  Calendar.AM_PM                   => am pm  
   *  Calendar.HOUR                    => h  
   *  Calendar.HOUR_OF_DAY             => hour of day  
   *  Calendar.WEEK_OF_MONTH           => week of month  
   *  Calendar.WEEK_OF_YEAR            => week of year  
   *  Calendar.ZONE_OFFSET             => zone offset  
   * </pre>
   */
  public static String getFieldName( int _field )
  {
    if( _field == Calendar.YEAR ) return "year";  
    if( _field == Calendar.MONTH ) return "month";  
    if( _field == Calendar.DST_OFFSET ) return "dst_offset";  
    if( _field == Calendar.DAY_OF_MONTH ) return "day of month";  
    if( _field == Calendar.MILLISECOND ) return "ms";  
    if( _field == Calendar.SECOND ) return "s";  
    if( _field == Calendar.DAY_OF_WEEK_IN_MONTH ) return "day of week in monthday";  
    if( _field == Calendar.DAY_OF_YEAR ) return "day of year";  
    if( _field == Calendar.DAY_OF_WEEK ) return "day of week";  
    if( _field == Calendar.ERA ) return "era";  
    if( _field == Calendar.AM_PM ) return "am pm";  
    if( _field == Calendar.HOUR ) return "h";  
    if( _field == Calendar.HOUR_OF_DAY ) return "hour of day";  
    if( _field == Calendar.WEEK_OF_MONTH ) return "week of month";  
    if( _field == Calendar.WEEK_OF_YEAR ) return "week of year";  
    if( _field == Calendar.ZONE_OFFSET ) return "zone offset";  
    return Integer.toString(_field);
  }
  
  /**
   * @return the index of the calendar field corresponding the name in
   * the strin parameter
   */
  public static int getFieldIndex(String name)
  {
      if ("year".equals(name))          return Calendar.YEAR;
      if ("month".equals(name))         return  Calendar.MONTH;  
      if ("dst_offset".equals(name))    return Calendar.DST_OFFSET;  
      if ("day of month".equals(name))  return Calendar.DAY_OF_MONTH;  
      if ("ms".equals(name))            return Calendar.MILLISECOND;  
      if ("s".equals(name))             return Calendar.SECOND;  
      if ("day of week in monthday".equals(name))  return Calendar.DAY_OF_WEEK_IN_MONTH;  
      if ("day of year".equals(name))   return Calendar.DAY_OF_YEAR;  
      if ("day of week".equals(name))   return Calendar.DAY_OF_WEEK;  
      if ("era".equals(name))           return Calendar.ERA;  
      if ("am pm".equals(name))         return Calendar.AM_PM;  
      if ("h".equals(name))             return Calendar.HOUR;  
      if ("hour of day".equals(name))   return Calendar.HOUR_OF_DAY;  
      if ("week of month".equals(name)) return Calendar.WEEK_OF_MONTH;  
      if ("week of year".equals(name))  return Calendar.WEEK_OF_YEAR;  
      if ("zone offset".equals(name))   return Calendar.ZONE_OFFSET; 
      return -1;
  }
  
  /**
   * Writes the object in a string which has an xml syntax
   */
  public String writeXml()
  {
    String xml=null;
    for( int i=0; i<fields_.length; ++i )
    {
      if(xml!=null) xml += ","; else xml="";
      if( set_[i] )
      {
        xml += Integer.toString( fields_[i] );
      }
    }
    return xml;
  }
  
  public void readXml( Node node )
  {
     reset();
     String s = DXmlReader.getNodeText( node );
     if( s==null ) return ;
     String f[] = s.split(",");
     for( int i=0; i<f.length; ++i )
     {
       if( f[i].length() > 0 )
       {
         try
         {
           fields_[i] = Integer.parseInt( f[i] );
           set_[i] = true;
         }
         catch( NumberFormatException e ) {}
       }
     }
  }

  /**
   * Translates a Calendar Field content to an equivalent string.
   * Ex: year, 1, month, 3
   */
  public String serializeToString() {
      String ret="";
      for( int i=0; i<fields_.length; ++i )
      {
        if(ret.length()>0 && set_[i]) ret += ",";
        if( set_[i] )
          ret += getFieldName(i) + ", " + Integer.toString( fields_[i] );
      }
      return ret;
  }

  /**
   * Uses the string character to catch the information and store
   * it in the object.
   */
  public void serializeFromString(String s) {
      if( s==null ) return ;
      String f[] = s.split(",");
      for( int i=0; i<f.length; i++ )
      {
        if( (f[i].length() > 0) && (i+1<f.length) )
        {
           int index;
           if ((index=getFieldIndex(f[i]))!=-1)
           {
               try {
                  fields_[index] = Integer.parseInt( f[i+1].trim() );
                  set_[index] = true;
               } catch( NumberFormatException e ) {}
           }
        }
      }
    
  }

}
