/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DAlignment.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 3 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.tools.internal;


import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IDXmlSerializable;
import org.w3c.dom.Node;


/**
 * XML Serializable object storing alignement value.
 * Alignment are used in DParagraph class and for any properties of DGraphic class.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DAlignment implements IDAlignment, IDXmlSerializable
{
   /** store current alignment bit field. */
   protected int align_;
  
   /** 
    * Create default alignment
    */
   public DAlignment()
   {
     align_ = DEFAULT_ALIGN;
   }
   
   /**
    * Create a alignment using given mask.
    * @see IDAlignment
    */
   public DAlignment( int _align )
   {
     align_=_align;
   }
   
   /**
    * Create copy of alignment
    */
   public DAlignment( DAlignment _align )
   {
     align_=_align.getAlignment();
   }
  
   /**
    * Returns the aligment flag.
    * @see IDAlignment
    */
   public int getAlignment()
   {
     return align_;
   }

   public int  getAlignment( int _alignment_mask )
   {
     return align_&_alignment_mask; 
   }

   /**
    * Sets the aligment value
    * @see IDAlignment
    */
   public void setAlignment( int _align )
   {
     align_ = _align;
   }
  
   /**
    * Adds an aligment indicator
    * @see IDAlignment
    */
   public void addAlignment( int _align )
   {
     align_ |= _align;
   }
   
   public void removeAlignment( int _align )
   {
     align_ &= ~_align;
   }
   
   /**
    * @return true if primary alignment contains full combined mask _align.
    */
   public boolean haveAlignment( int _alignment )
   {
     return (getAlignment()&_alignment)==_alignment;
   }

   /**
    * @return true if primary alignment contains full combined mask _align.
    */
   public boolean haveOneOfAlignment( int _alignment )
   {
     return (getAlignment()&_alignment)!=0;
   }
 
   /* must have same definition as IDAlignment */
   private static String bits_name [] =
   {
     /*0x0001*/ "LEFT",     /*0x0002*/ "RIGHT",    /*0x0004*/ "HCENTER",
     /*0x0008*/ "TOP",      /*0x0010*/ "BOTTOM",   /*0x0020*/ "VCENTER",
     /*0x0040*/ "VERTICAL", /*0x0080*/ "ROTCCW90", /*0x0100*/ "ROTCW90"
   };
   
   /**
    * Returns the paragraph alignment property name without prefix.
    * @param a alignment property
    */
   public static String AlignmentToString(int a) 
   {
     String s=null;

     //9: is bit for last IDAlignment bit definition.
     for( int bit=0, mask=0x0001; mask<=LAST; bit++,mask<<=1 )
     {
       if( HaveAlignment( a, mask ) )
       {
         if( s==null )
         {
           s = bits_name[bit];
         }
         else
         {
           s += "|" + bits_name[bit];
         }
       }
     }
     return s;
   }
   
   /**
    * Returns the translation of aligment given in string characters to its
    * representation in integer value. 
    */
   public static int StringToAlignment(String s) 
   {
      int align = 0;

      String[] list = s.split("\\|");
      
      for (int i = 0; i < list.length; i++ )
      {
        String al = list[i];
        for( int b=0; b<bits_name.length; ++b )
        {
          if( bits_name[b].compareTo( al ) ==0 )
          {
            align |= (1<<b);
          }
        }
      }   
      return align;
   }
  
   /**
    * @return true if _alignment mask contains all alignment defined in _mask
    * for example IsAlignement( LEFT|TOP, LEFT) return true.
    */
   public static boolean HaveAlignment( int _alignment, int _mask )
   {
     return (_alignment&_mask)==_mask;
   }
   
   /**
    * @return alignement plus alignment to add.
    */
   public static int AddAlignment( int _alignment, int _add_alignment )
   {
     return _alignment | _add_alignment;
   }
   
   /**
    * @return alignment where alignments to remove are removed
    */
   public static int RemoveAlignment( int _alignment, int _remove_alignment )
   {
     return _alignment & (~_remove_alignment);
   }
   
   /**
    * Writes an alignment value in string store in XML files
    */
   public String writeXml()
   {
     return AlignmentToString( align_ );
   }
  
   /**
    * Reads an alignment stored in XML file parsed with DOM module
    */
   public void readXml( Node node )
   {
     int align = StringToAlignment( DXmlReader.getNodeText( node ));
     setAlignment( align );
   }
   
   /**
    * Compares two aligments and returns true if they are equals
    */
  public boolean equals( Object o )
  {
    if( o == this ) return true;
    if( !(o instanceof DAlignment) ) return false;
    DAlignment oa = (DAlignment)o;
    return ( oa.align_ == this.align_);
  }

}
