/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DAlignmentPair.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 3 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.tools.internal;


import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.w3c.dom.Node;

/**
 * Used to store two alignment.
 * First is the primary alignment (the inherited one), second is ... secondary alignment.
 * Alignment mask and values are defined in IDAlignment.
 * 
 * @see IDAlignment
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DAlignmentPair extends DAlignment
{
  int aln_secondary_ ;
  
  /**
   * Create a default alignment
   */
  public DAlignmentPair()
  {
    setSecondaryAlignment( IDAlignment.DEFAULT_ALIGN );
  }
  
  /**
   * Create an alignment pair, using default for secondary alignment.
   */
  public DAlignmentPair( int _align )
  {
    super( _align );
    setSecondaryAlignment( IDAlignment.DEFAULT_ALIGN );
  }
  
  /**
   * Create a full featured alignment pair
   */
  public DAlignmentPair( int _align, int _secondary_alignment )
  {
    super( _align );
    setSecondaryAlignment( _secondary_alignment );
  }
  
  /** 
   * Create copy of alignement pair.
   */
  public DAlignmentPair( DAlignmentPair p )
  {
    super( p );
    setSecondaryAlignment( p.getSecondaryAlignment() );
  }
  
  public int getSecondaryAlignment()
  {
    return aln_secondary_;
  }
  
  /**
   * @return true if secondary alignment contains full combined mask _align.
   */
  public boolean haveSecondaryAlignment( int _alignment )
  {
    return (getSecondaryAlignment()&_alignment)==_alignment;
  }

  
  public void setSecondaryAlignment( int _alignment )
  {
    aln_secondary_ = _alignment;
  }
  
  public void addSecondaryAlignment( int _alignment )
  {
    aln_secondary_ |= _alignment;
  }
  
  public void removeSecondaryAlignment( int _alignment )
  {
    aln_secondary_ &= ~_alignment;
  }

  public String writeXml()
  {
    String primary   = super.AlignmentToString( getAlignment() );
    String secondary = super.AlignmentToString( getSecondaryAlignment() );
    
    if( primary  ==null ) primary="";
    if( secondary==null ) secondary="";

    return primary+"/"+secondary;
  }
  
  public void readXml( Node node )
  {
     String s = DXmlReader.getNodeText( node );
     String vs[] = s.split("/"); //must differ than DAlignment.separator();

     if( vs.length >= 1 )
     {
       setAlignment( StringToAlignment( vs[0] ));
     } else {
       setAlignment( IDAlignment.DEFAULT_ALIGN );
     }
     if( vs.length >=2 )
     {
       setSecondaryAlignment( StringToAlignment(vs[1]));
     } else {
       setSecondaryAlignment( IDAlignment.DEFAULT_ALIGN );
     }
  }
  
  public boolean equals( Object o )
  {
    if( o == this ) return true;
    if( !(o instanceof DAlignmentPair) ) return false;
    DAlignmentPair op = (DAlignmentPair)o;
    if( op.getAlignment() != getAlignment() ) return false;
    if( op.getSecondaryAlignment() != getSecondaryAlignment() ) return false;
    return true;
  }
}
