/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DChartTranslator.java,v 1.32 2008/12/12 22:22:08 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.tools.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.internal.MinMax;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DefaultResources;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.DPalettes;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.DShapes;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;

/**
 *Translate new format to old format
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DChartTranslator extends DParser {

    
    private static class Axis {
        
        public  Axis() {
            categories = new HashMap();
        }
        Map      categories;
        DAxis    axis;
    }
    
    private static class Arg {
        DGraphic graph;
        DGraphic chart;
        Axis     current_axis;
        List     curves;
        Map      curveNames;
        Map      axes;
        DPoint   current_point;
        DCurve   current_curve;
        DStyle   current_style;
        List     current_coord;
        String   ctype;
        int      nbaxes;
        IPalette palette;
        SVGColorPalettes palettes;
        boolean  split_in_curve = true;
        //MinMax   minmax_y;
        Map      minmax_ys;
        double   total;
        LinkedList markers;
        Object   v_min;
        Object   v_max;
        ULocale   locale;
        
        public Arg() {
            
            curves = new LinkedList();
            curveNames = new HashMap();
            axes = new HashMap();
            current_coord = new LinkedList();
            markers = new LinkedList();
            minmax_ys = new HashMap();
           
        }
        
        public MinMax minmax_y(String axname)
        {
            return (MinMax)minmax_ys.get(axname);
        }
    }
    
    String[] symbols = new String[5];
    
    private void copyProperties(DPropertyStore src, DPropertyStore dest)
    {
        Map msrc = src.elements();
        Map mdest = dest.elements();
        
        if (msrc==null) return;
        
        Set keys = msrc.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext())
        {
            String key = (String)it.next();
            dest.store(key, msrc.get(key));
        }
    }
    
    private DStyleRegistry styles = new DStyleRegistry(); 
    
    DColor white = new DColor(255, 255, 255);
    DColor black = new DColor(0, 0, 0);

    DFont chartFont = new DFont("Arial", null, 14, IDFont.NORMAL); //$NON-NLS-1$
    DFont axisFont = new DFont("Arial", null, 8, IDFont.NORMAL); //$NON-NLS-1$
    DFont curveFont = new DFont("Arial", null, 8, IDFont.NORMAL); //$NON-NLS-1$
    
    
    public DGraphic translate(DGraphic graph)
    {
        // init symbol
        symbols[0]=DSymbolRegistry.GetOval().getId();
        symbols[1]=DSymbolRegistry.GetDiamond().getId();
        symbols[2]=DSymbolRegistry.GetSquare().getId();
        symbols[3]=DSymbolRegistry.GetStar().getId();
        symbols[4]=DSymbolRegistry.GetHexagon().getId();
        
        // init Styles
        // Colors
        
        
        styles.putStyle(new DStyle("Chart", chartFont, black, white)); //$NON-NLS-1$
        styles.putStyle(new DStyle("Axis", axisFont, black, white)); //$NON-NLS-1$
        
        if (graph.getStyle()==null)
            graph.setStyle(styles.getFirstStyle("Chart")); //$NON-NLS-1$
        
        
        // init palettes
        DefaultResources resources = new DefaultResources();
        
        String ctype = graph.getGraphicType();
        DGraphic chart = new DGraphic();
        
        // search locale
        ULocale locale;
        DI18N i18n = (DI18N)graph.getChildOfClass(DI18N.class);
        if (i18n!=null) {
            locale = new ULocale(i18n.getLanguage(), i18n.getCountry());
            DI18N ni18n = new DI18N();
            ni18n.setCountry(i18n.getCountry());
            ni18n.setLanguage(i18n.getLanguage());
            ni18n.setTextDirection(i18n.getTextDirection());
            ni18n.setTimeZone(i18n.getTimeZone());
            ni18n.setResourceBundle(i18n.getResourceBundle());
            chart.addChild(ni18n);
        }
        else
            locale = ULocale.getDefault();
        
        chart.setHeightScale(graph.getHeightScale());
        chart.setWidthScale(graph.getWidthScale());
        
        // duplicate properties
        copyProperties(graph.getProperties(), chart.getProperties()); 
   
        chart.setStyle(graph.getStyle());
        chart.setTitle(graph.getTitle());
        
        Arg arg = new Arg();
        arg.graph = graph;
        arg.chart = chart;
        arg.ctype = ctype;
        arg.locale = locale;
        arg.palettes = new SVGColorPalettes(resources, arg.locale);
        initPalette(resources.getResourceDir(),
                    resources.getDefaultPalettesId(),
                    resources.getDefaultPaletteSetId().toString(),arg);
        
        if ("pie".equals(ctype)) //$NON-NLS-1$
        {
	         chart.setRenderableId(DGraphic.T_SECTORS);
	         arg.nbaxes = 1;
        }
	    else
	    if ("pie3D".equals(ctype)) //$NON-NLS-1$
	    {
	         chart.setRenderableId(DGraphic.T_SECTORS3D);
	         arg.nbaxes = 1;
	    }
	    else
	    if ("3Dpie".equals(ctype)) { //$NON-NLS-1$
		     chart.setRenderableId(DGraphic.T_PIE3D);
		     arg.nbaxes = 1;
	    }
		else
	    if ("xy".equals(ctype) || "line".equals(ctype)) { //$NON-NLS-1$ //$NON-NLS-2$
	         chart.setRenderableId(DGraphic.T_XY);
	         arg.nbaxes = 2;
	    }
	    else
	    if ("horizontalBar".equals(ctype)) { //$NON-NLS-1$
	         chart.setRenderableId(DGraphic.T_H_HISTOGRAM_IM);
	         chart.getProperties().store(DGraphic.P_THIN_BAR, true);
	         arg.nbaxes = 1;
	     }
	    else
	     if ("verticalBar".equals(ctype)) { //$NON-NLS-1$
	         chart.setRenderableId(DGraphic.T_HISTOGRAM_IM);
	         chart.getProperties().store(DGraphic.P_THIN_BAR, true);
	         arg.nbaxes = 1;
	     }
	     else
	     if ("horizontalBar3D".equals(ctype)) { //$NON-NLS-1$
	         chart.setRenderableId(DGraphic.T_H_HISTOGRAM_IM);
	         chart.getProperties().store(DGraphic.P_3D, true);
	         chart.getProperties().store(DGraphic.P_THIN_BAR, true);
	         arg.nbaxes = 1;
	     }
	     else
	     if ("verticalBar3D".equals(ctype)) { //$NON-NLS-1$
	         chart.setRenderableId(DGraphic.T_HISTOGRAM_IM);
	         chart.getProperties().store(DGraphic.P_3D, true);
	         chart.getProperties().store(DGraphic.P_THIN_BAR, true);
	         arg.nbaxes = 1;
        }
	     else
	     if ("horizontalStackedBar".equals(ctype)) { //$NON-NLS-1$
	         chart.setRenderableId(DGraphic.T_H_STACKBARS);
	         chart.getProperties().store(DGraphic.P_THIN_BAR, true);
	         arg.nbaxes = 1;
	         arg.split_in_curve = false;
	     }
	     else
	     if ("verticalStackedBar".equals(ctype)) { //$NON-NLS-1$
	         chart.setRenderableId(DGraphic.T_STACKBARS);
	         chart.getProperties().store(DGraphic.P_THIN_BAR, true);
	         arg.nbaxes = 1;
	         arg.split_in_curve = false;
	     }
	     else
	     if ("horizontalStackedBar3D".equals(ctype)) { //$NON-NLS-1$
	         chart.setRenderableId(DGraphic.T_H_STACKBARS);
	         chart.getProperties().store(DGraphic.P_3D, true);
             chart.getProperties().store(DGraphic.P_THIN_BAR, true);
	         arg.nbaxes = 1;
	         arg.split_in_curve = false;
	     }
	     else
	     if ("verticalStackedBar3D".equals(ctype))  { //$NON-NLS-1$
	         chart.setRenderableId(DGraphic.T_STACKBARS);
	         chart.getProperties().store(DGraphic.P_3D, true);
	         chart.getProperties().store(DGraphic.P_THIN_BAR, true);
	         arg.nbaxes = 1;
	         arg.split_in_curve = false;
        }
	     else
	     if ("meter".equals(ctype)) { //$NON-NLS-1$
	         chart.setRenderableId(DGraphic.T_METER);
	         arg.nbaxes = 1;
             if (!graph.getProperties().hasKey(DAxis.P_UNIT_FORMAT))
             {
                NumberFormat number = DecimalFormat.getIntegerInstance(locale);
                number.setMaximumIntegerDigits(1);
                chart.getProperties().store(DAxis.P_UNIT_FORMAT, number);
             }
	     }
	     else
		 if ("xysurface".equals(ctype)) { //$NON-NLS-1$
		     chart.setRenderableId(DGraphic.T_XY_SURFACE);
		     arg.nbaxes = 2;
		 }
		 else
		 if ("3Dtorus".equals(ctype)) //$NON-NLS-1$
		     chart.setRenderableId(DGraphic.T_TORUS3D);
		 else
		 if ("xyz".equals(ctype)) //$NON-NLS-1$
		     chart.setRenderableId(DGraphic.T_XYZ);
		 else
		 if ("wireframe".equals(ctype)) //$NON-NLS-1$
		     chart.setRenderableId(DGraphic.T_WIREFRAME);
		 else
		 if ("radar".equals(ctype)) //$NON-NLS-1$
		     chart.setRenderableId(DGraphic.T_HISTORS);
		 else 
		 if ("3Dseries".equals(ctype)) //$NON-NLS-1$
		     chart.setRenderableId(DGraphic.T_SERIES3D);
		 else
		 if ("area".equals(ctype) || "stackedArea".equals(ctype)) { //$NON-NLS-1$ //$NON-NLS-2$
			 chart.setRenderableId(DGraphic.T_XY);
			 arg.nbaxes = 2;
		 }
		 else
		 if ("scatter".equals(ctype)) { //$NON-NLS-1$
			 chart.setRenderableId(DGraphic.T_XY);
			 arg.nbaxes = 2;
		 }
		 else
		 {
		     return graph;
		 }
		 
//      parses palettes
        for (IDItem c=graph.getFirstChild(); c!=null; c=c.getNext())
        {
            if (c instanceof DPalettes)
                invokeDoMethod(c, this, arg);
        }
         
         // parses axes
         for (IDItem c=graph.getFirstChild(); c!=null; c=c.getNext())
         {
             if (c instanceof DAxis)
                 invokeDoMethod(c, this, arg);
         }
         
         nbcolor = graph.getChildrenOfClass(DCurve.class).size();
         
         for (IDItem c=graph.getFirstChild(); c!=null; c=c.getNext())
         {
             if (!(c instanceof DAxis))
                 invokeDoMethod(c, this, arg);
         }
         
         //
         if ("meter".equals(arg.ctype))
         {    
             Iterator it = arg.markers.iterator();
             TreeMap tm = new TreeMap();
             while (it.hasNext())
             {
                DMarkerLine ml = (DMarkerLine)it.next();
                tm.put(ml.getValue(), ml);
             }
             
            it = tm.values().iterator();
            int i=0;
            double max = 0;
            IDItem prev = arg.chart.getLastChild();
            while (it.hasNext())
            {
               DMarkerLine ml = (DMarkerLine)it.next();
               
               DCurve curve = new DCurve();
               curve.setName(ml.getLabel());
               
               DStyle s = new DStyle();
               if (ml.getColor()!=null)
                  s.setBackColor(ml.getColor());
               else
                  s.setBackColor(arg.palette.getColor((i+1)%arg.palette.getNumColors()));
               s.setFont(curveFont);
               curve.setStyle(s);
               
               DPoint p;
               curve.addChild(p = new DPoint());
               p.addChild(new DCoord(((Axis)arg.axes.get("y")).axis,
                       ((Double)ml.getValue()).doubleValue()));
               max = Math.max(max, ((Double)ml.getValue()).doubleValue());
               arg.chart.addChild(curve);
            }
            
            DAxis ax = ((Axis)arg.axes.get("y")).axis;
            if (!ax.getProperties().hasKey(DAxis.P_MAX) && (tm.values().size()>0))
                ax.getProperties().store(DAxis.P_MAX, max);
         }
         
         checkGraphic(chart, arg);
         
         computeMajorAndMinorUnit(chart, arg);
         return chart;
    }
    
    
    private void calculateMinMax(DAxis ax, Arg arg)
    {
        if ("stackedArea".equals(arg.ctype)) //$NON-NLS-1$
        {
            calculateStackedAreaMinMax(ax, arg);
        }
        else
        if ("verticalStackedBar".equals(arg.ctype) //$NON-NLS-1$
            || "verticalStackedBar3D".equals(arg.ctype) //$NON-NLS-1$
            || "horizontalStackedBar".equals(arg.ctype) //$NON-NLS-1$
            || "horizontalStackedBar3D".equals(arg.ctype)) //$NON-NLS-1$
        {
            calculateStackedBarMinMax(ax, arg);
        }
        else
        {
            arg.v_max = arg.minmax_y(ax.getName()).getVMax();
            arg.v_min = arg.minmax_y(ax.getName()).getVMin();
        }
           
    }
    
    
    private Object getMax(DAxis ax, Arg arg)
    {
        if ("stackedArea".equals(arg.ctype)) //$NON-NLS-1$
        {
            return arg.minmax_y(ax.getName()).getVMax();
        }
        else
        if ("verticalStackedBar".equals(arg.ctype) //$NON-NLS-1$
            || "verticalStackedBar3D".equals(arg.ctype) //$NON-NLS-1$
            || "horizontalStackedBar".equals(arg.ctype) //$NON-NLS-1$
            || "horizontalStackedBar3D".equals(arg.ctype)) //$NON-NLS-1$
        {
            return arg.minmax_y(ax.getName()).getVMax();
        }
        else
            return arg.minmax_y(ax.getName()).getVMax();
    }
    
    
    
    private Object getMin(DAxis ax, Arg arg)
    {
        if ("stackedArea".equals(arg.ctype)) //$NON-NLS-1$
        {
            return arg.minmax_y(ax.getName()).getVMin();
        }
        else
        if ("verticalStackedBar".equals(arg.ctype) //$NON-NLS-1$
            || "verticalStackedBar3D".equals(arg.ctype) //$NON-NLS-1$
            || "horizontalStackedBar".equals(arg.ctype) //$NON-NLS-1$
            || "horizontalStackedBar3D".equals(arg.ctype)) //$NON-NLS-1$
        {
            return arg.minmax_y(ax.getName()).getVMin();
        }
        else
            return arg.minmax_y(ax.getName()).getVMin();
    }
    
    private void computeMajorAndMinorUnit(DGraphic graph, Arg arg)
    {
         
         // sets the min and max value on the axis
         for (IDItem c=graph.getFirstChild(); c!=null; c=c.getNext())
         {
             if (c instanceof DAxis)
             {
                 DAxis ax = (DAxis)c;
                 
                 boolean hasMinMax = (ax.getProperties().hasKey(DAxis.P_MAX)
                                       && ax.getProperties().hasKey(DAxis.P_MIN));
                 
                 if (isContinueAxis(ax, arg))         
                 {
                     calculateMinMax(ax, arg);
                     
                     Object maxo= null;
                     if (ax.getProperties().hasKey(DAxis.P_MAX))
                         maxo = ax.getProperties().get(DAxis.P_MAX);
                     else
                         maxo = arg.v_max;
                     
                     Object mino = null;
                     if (ax.getProperties().hasKey(DAxis.P_MIN))
                         mino = ax.getProperties().get(DAxis.P_MIN);
                     else
                         mino =  arg.v_min;
                     
                     if (maxo==null)
                         maxo = new Double(1);
                     
                     if (mino==null)
                         mino = new Double(0);
                
                     boolean isLinear = ax.getScaleType().equals(DAxis.S_LIN);
                     
                     if ((mino instanceof Double)&&(maxo instanceof Double))
                     {
                         double max = ((Double)maxo).doubleValue();
                         double min = ((Double)mino).doubleValue();
                         
                         //  modify min and max if min == max
                         if (max==min)
                         {
                             max = max + 1;
                             min = min - 1;
                         }
                         
                         boolean findOrderOfMagnitude = !ax.getProperties().hasKey(DAxis.P_MAJUNIT_VALUE)
                                          && !ax.getProperties().hasKey(DAxis.P_MINUNIT_VALUE);
                         
                         double orderOfMagnitude = 1.0;
                         if (findOrderOfMagnitude) {
                            orderOfMagnitude = getOrderOfMagnitude(max, min);
                         }
                         
                         
                         double majorUnit = ax.getProperties().get(DAxis.P_MAJUNIT_VALUE, 1.0);
                         double minorUnit = ax.getProperties().get(DAxis.P_MINUNIT_VALUE, 1.0);
                         
                         if (!ax.getProperties().hasKey(DAxis.P_MAJUNIT_VALUE)) {
                            if ((max - min)/orderOfMagnitude > 5) {
                                majorUnit = orderOfMagnitude * 2;
                            } else {
                                majorUnit = orderOfMagnitude;
                            }
                        }
                         
                        if (!ax.getProperties().hasKey(DAxis.P_MINUNIT_VALUE)) {
//                      {
                           minorUnit = majorUnit / 2;
                        }
                        
                        if (isLinear) {
                            if (!ax.getProperties().hasKey(DAxis.P_MAX)) {
                                if (max < 0) {
                                    max = 0;
                                } else {
                                    // find axisMax from dataMax and major unit
                                    max = Math.floor(max / majorUnit) * majorUnit + majorUnit;
                                }
                            }
                            if (!ax.getProperties().hasKey(DAxis.P_MIN)) {
                                if (min >= 0) {
                                    min = 0;
                                } else {
                                    min = (Math.floor(Math.abs(min) / majorUnit) * majorUnit + majorUnit) * (-1); 
                                }
                            }
                        } else {
                            if (!ax.getProperties().hasKey(DAxis.P_MAX)) {
                               // max = Math.round(Math.log(getOrderOfMagnitude(max) * 10)/Math.log(10));
                                max = Math.round((getOrderOfMagnitude(max) * 10));
                                
                            }
                            if (!ax.getProperties().hasKey(DAxis.P_MIN)) {
                               // min = Math.round(Math.log(getOrderOfMagnitude(min))/Math.log(10));
                                min = getOrderOfMagnitude(min)/10;
                               
                            }
                        }
                        
                        // if max < min, exchange values of max and min.
                        if (max < min) {
                            double tmp = max;
                            max = min;
                            min = tmp;
                        }
                         
                         Object majorUnitValueo = ax.getProperties().get(DAxis.P_MAJUNIT_VALUE, new Double(majorUnit)); //new Double(5.0));
                         Object minorUnitValueo = ax.getProperties().get(DAxis.P_MINUNIT_VALUE, new Double(minorUnit));
                         
                         double step_unit = ((Double)majorUnitValueo).doubleValue(); //majorUnit;
                         double step_line = ((Double)minorUnitValueo).doubleValue(); //minorUnit;
            
                         if (!ax.getProperties().hasKey(DAxis.P_MAX))
                             ax.getProperties().store(DAxis.P_MAX, max);    
                         
                         if (!ax.getProperties().hasKey(DAxis.P_MIN))
                             ax.getProperties().store(DAxis.P_MIN, min);
                         
                         boolean showTick = ax.getProperties().get(DAxis.P_MAJUNIT_SHOWTICK, true);
                       
                         if (showTick && step_unit > 0)
                             ax.getProperties().store(DAxis.P_STEP_UNIT, step_unit);
                   
                         boolean showGrid = ax.getProperties().get(DAxis.P_MAJUNIT_SHOWGRID, true);
               	         if (showGrid && step_unit > 0)
               	            ax.getProperties().store(DAxis.P_STEP_LINE, step_line);
                     }
                     else
                     {
                     }
                 }
             }
         }
         
      
    }
    
    public void doMethod(DPalettes pal, DExtensible ext, Object the_arg)
    {
        Arg arg = (Arg)the_arg;
        
        
        initPalette(pal.getLocation(),pal.getPaletteId(), pal.getPaletteSetId(), arg);
       
    }
    
    /** initialise the IPalette from the SVG palette definition */
    private void initPalette(String loc, String pId, String psetId, Arg arg)
    {
        arg.palettes.setCustomPalettes(loc,pId, psetId);
        int pal[] = new int[arg.palettes.getPalette().length];
        for (int i=0; i<arg.palettes.getPalette().length; i++)
        {
            DColor c = new DColor();
            c.serializeFromString(arg.palettes.getPalette()[i]);
            pal[i] = (c.getRGBA()>>8);
        }
        arg.palette = new Palette(pal);
    }
    
    
    public void doMethod(DAxis ax, DExtensible ext, Object the_arg)
    {
        Arg arg = (Arg)the_arg;
        
        if (ax.getStyle()==null)
            ax.setStyle(styles.getFirstStyle("Axis")); //$NON-NLS-1$
        
        arg.current_axis = new Axis(); 
        arg.current_axis.axis = new DAxis(ax.getName());
        arg.current_axis.axis.setStyle(ax.getStyle());     
        
        nbcolor = ax.getChildCount();
        doChildrenItem(ax, this, arg);

        // duplicate properties
        copyProperties(ax.getProperties(), arg.current_axis.axis.getProperties()); 
        
        
        String val = (String)arg.current_axis.axis.getProperties().get(DAxis.P_LABEL_ROTATION,
                                               DAxis.S_ZERO_DEGREE);
        if (DAxis.S_MINUS_NINTY_DEGREE.equals(val))
        {
            arg.current_axis.axis.getProperties().store(DAxis.P_LABEL_ALIGNMENT,
                                            new DAlignment(DAlignment.ROTCCW90));
        }
        else
        if (DAxis.S_PLUS_NINTY_DEGREE.equals(val))
        {
            arg.current_axis.axis.getProperties().store(DAxis.P_LABEL_ALIGNMENT,
                                            new DAlignment(DAlignment.ROTCCW90));
        }
        
        arg.current_axis.axis.setScaleType(ax.getScaleType());
        
     //   if ("log".equals(ax.getScaleType()))
     //      arg.current_axis.axis.setScaleType(DAxis.S_LOG);
        arg.current_axis.axis.setTitle(ax.getTitle());
        arg.current_axis.axis.setTooltip(ax.getTooltip());
        arg.current_axis.axis.setUnit(ax.getUnit());
        arg.axes.put(arg.current_axis.axis.getName(), arg.current_axis);
        
        if (arg.current_axis.categories.size()>0)
        {
            arg.current_axis.axis.getProperties().store(DAxis.P_MAX, arg.current_axis.categories.size()+1);
            arg.current_axis.axis.getProperties().store(DAxis.P_MIN, 0);
        }
        
        if ((arg.nbaxes==1) && (arg.current_axis.categories.size()==0))
        { 
            arg.chart.addChild(arg.current_axis.axis);
        }
        else
        if (arg.nbaxes==2)
        {
            arg.chart.addChild(arg.current_axis.axis);
        }
            
        boolean showTick = ax.getProperties().get(DAxis.P_MAJUNIT_SHOWTICK, true);
        if ((arg.current_axis.categories.size()>0) && showTick)
        {
            ax.getProperties().store(DAxis.P_STEP_UNIT, 1.0);
        }
        
        if (isContinueAxis(ax, arg))
        {
            arg.minmax_ys.put(ax.getName(), new MinMax(arg.current_axis.axis));
        }
        else
        {
            if (showTick)
                arg.current_axis.axis.getProperties().store(DAxis.P_STEP_UNIT, 1);
        }
        
       
        
    }
    
    public void doMethod(DCategory cat, DExtensible ext, Object the_arg)
    {
        Arg arg = (Arg)the_arg;
        arg.current_axis.categories.put(cat.getId(),new Double(arg.current_axis.categories.size()+1));
        arg.curveNames.put(cat.getId(), cat.getLabel());
        
        DCategory categ = new DCategory();
        categ.setId(cat.getId());
        categ.setLabel(cat.getLabel());
        arg.current_axis.axis.addChild(categ);
    }
    
    private int nbcolor = 0;
    private int lastColor = 0;
    
    public void doMethod(DCurve curve, DExtensible ext, Object the_arg)
    {
        Arg arg = (Arg)the_arg;
       
        IDColor color = (IDColor)curve.getProperties().get(DCurve.P_COLOR);
        if (color==null)
        {
            color = arg.palette.getColor(lastColor);
            
        }
        DStyle sty = new DStyle();
        sty.setFont(curveFont);
        sty.setForeColor(black);
        if (!"meter".equals(arg.ctype))
        {
            sty.setBackColor(color);
        }
        else
        {
            ((Axis)arg.axes.get("y")).axis.setTitle(curve.getName());
        }
        arg.current_style = sty;
        
      
        DCurve c = new DCurve();
        
        c.setName(curve.getName());
        c.setTooltip(curve.getTooltip());
        c.setStyle(curve.getStyle());
            
        DShapes shapes = (DShapes)arg.graph.getChildOfClass(DShapes.class);
        boolean showShape = true;
        if (shapes!=null)
            showShape = shapes.isShow();
            
        // duplicate properties
        copyProperties(curve.getProperties(), c.getProperties()); 
        
        if ("area".equals(arg.ctype)) //$NON-NLS-1$
        {
            c.getProperties().store(DCurve.P_SYMBOL, symbols[(lastColor)%5] );
            if (showShape)
                c.setType(DCurve.T_AREA_LINE_POINTS);
            else
                c.setType(DCurve.T_AREA_LINE);
        }
        else
        if ("scatter".equals(arg.ctype)) //$NON-NLS-1$
        {
            c.getProperties().store(DCurve.P_SYMBOL, symbols[(lastColor)%5] );
            c.setType(DCurve.T_POINTS);
        }
        else
        if ("line".equals(arg.ctype)) //$NON-NLS-1$
        {
            c.getProperties().store(DCurve.P_SYMBOL, symbols[(lastColor)%5] );
            if (showShape)
               c.setType(DCurve.T_LINE_POINTS);
            else
               c.setType(DCurve.T_LINE);
        }
        else
        if ("stackedArea".equals(arg.ctype)) //$NON-NLS-1$
        {
            c.getProperties().store(DCurve.P_SYMBOL, symbols[(lastColor)%5] );
            if (showShape)
               c.setType(DCurve.T_STACKED_AREA_LINE_POINTS);
            else
               c.setType(DCurve.T_STACKED_AREA_LINE);
        }
      
        arg.chart.addChild(c);
        
        arg.curves.add(c);
        arg.current_curve = c;
            
               
        if (("pie".equals(arg.ctype)) || ("pie3D".equals(arg.ctype))) //$NON-NLS-1$ //$NON-NLS-2$
        {
            for (IDItem ci = curve.getFirstChild(); ci!=null; ci=ci.getNext())
            {
                if (ci instanceof DPoint)
                {
                    for (IDItem ci2 = ((DPoint)ci).getFirstChild(); ci2!=null; ci2=ci2.getNext())
                    {
                        if (ci2 instanceof DCoord)
                            arg.total += ((DCoord)ci2).getValue();
                    }
                }
            }
        }
        
        lastColor = lastColor + 1; 
        
        doChildrenItem(curve, this, arg);
    }
    
    public void doMethod(DMarkerLine ml, DExtensible ext, Object the_arg)
    {
        Arg arg = (Arg)the_arg;
        
        DMarkerLine ml2 = new DMarkerLine();
        ml2.setColor(ml.getColor());
        ml2.setId(ml.getId());
        ml2.setLabel(ml.getLabel());
        ml2.setStyle(ml.getStyle());
        ml2.setThickness(ml.getThickness());
        ml2.setValue(ml.getValue());
        
        arg.current_axis.axis.addChild(ml2);
        arg.markers.add(ml2);
    }
    
    public void doMethod(DPoint point, DExtensible ext, Object the_arg)
    {
        Arg arg = (Arg)the_arg;
        
        DPoint p = new DPoint();
        p.setId(point.getId());
        p.setTooltip(point.getTooltip());
        p.setType(point.getType());
        p.setStyle(point.getStyle());
        arg.current_point = p;
        
        doChildrenItem(point, this, arg);
        
        arg.current_curve.addChild(p);
        if (arg.current_curve.getStyle()==null)
            arg.current_curve.setStyle(arg.current_style);
    }
    
    boolean isContinueAxis(DAxis ax, Arg arg)
    {
        return ((((Axis)arg.axes.get(ax.getName())).categories!=null)
                && (((Axis)arg.axes.get(ax.getName())).categories.size() == 0));
       // return ("y".equals(ax.getName())) || ("y2".equals(ax.getName())); //$NON-NLS-1$ //$NON-NLS-2$
    }
    
    public void doMethod(DCoord coord, DExtensible ext, Object the_arg)
    {
        Arg arg = (Arg)the_arg;
        
        DCoord co = new DCoord();
        co.setValue(coord.getValue());
        Axis ax = (Axis)arg.axes.get(coord.getAxis().getName());
        if (ax==null)
        {
            System.err.println("the axis '" + coord.getAxis().getName() + "' not registred");
            throw new Error();
        }

        co.setAxis(ax.axis);
        co.setStyle(coord.getStyle());
        arg.current_point.addChild(co);
        
        if (isContinueAxis(ax.axis, arg))
        {
            // compute min max
            arg.minmax_y(ax.axis.getName()).update(coord);
            
            if (("pie".equals(arg.ctype)) || ("pie3D".equals(arg.ctype))) //$NON-NLS-1$ //$NON-NLS-2$
            {
                String mes =""; //$NON-NLS-1$
                
                NumberFormat performat = NumberFormat.getPercentInstance(arg.locale);
                performat.setMaximumIntegerDigits(3);
                performat.setMaximumFractionDigits(2);
      
                boolean show_per = arg.chart.getProperties().get(DGraphic.P_SHOW_PERCENTAGE, false);
                if (show_per)
                    mes = performat.format(new Double(coord.getValue()*100/arg.total)) + "%"; //$NON-NLS-1$
                    
                boolean show_val = arg.chart.getProperties().get(DGraphic.P_SHOW_VALUES, false);
                if (show_val)
                {
                    if (show_per) mes += " - "; //$NON-NLS-1$
                    UFormat f = (UFormat)ax.axis.getProperties().get(DAxis.P_UNIT_FORMAT);
                    if (f!=null)
                        mes += f.format(new Double(coord.getValue()));
                    else
                        mes += ""+coord.getValue();
                }
                
                DText t = (DText)arg.current_point.getChildOfClass(DText.class);
                if (t!=null)
                {
                   t.setText(mes);
                   t.setStyle(styles.getFirstStyle("Axis")); //$NON-NLS-1$
                }
                else
                {
                    DText txt = new DText(mes);
                    txt.setStyle(styles.getFirstStyle("Axis")); //$NON-NLS-1$
                    arg.current_point.addChild(txt);
                }
                    
            }
            
          // arg.min = Math.min(coord.getValue(),arg.min);    
        }
    }
    
    public void doMethod(DCoordObject coord, DExtensible ext, Object the_arg)
    {
        Arg arg = (Arg)the_arg;
        Object v = coord.getValue(null);
        
        Axis ax = (Axis)arg.axes.get(coord.getAxis().getName());
        if (ax==null)
        {
            System.err.println("the axis '" + coord.getAxis().getName() + "' not registred");
            throw new Error();
        }
        
        // compute min max
        if (isContinueAxis(ax.axis, arg))
        {
           arg.minmax_y(ax.axis.getName()).update(coord);
        }
        
        if (ax.categories.size()>0)
        {
 //           if (arg.nbaxes ==1 && arg.split_in_curve) 
 //               arg.current_curve = (DCurve)arg.curves.get((String)v);
 //           else
 //           if (arg.nbaxes ==2)
 //           {
                DCoord co = new DCoord();
                co.setValue((Double)ax.categories.get(v));
                co.setAxis(ax.axis);
                co.setStyle(coord.getStyle());
                arg.current_point.addChild(co);
 //           }
            
            DText txt = new DText((String)arg.curveNames.get(v));
            txt.setStyle(styles.getFirstStyle("Axis")); //$NON-NLS-1$
            arg.current_point.addChild(txt);
        }
        else
        {
            DCoordObject co = new DCoordObject();
            co.setValue(coord.getValue(null));
            co.setAxis(ax.axis);
            co.setStyle(coord.getStyle());
            arg.current_point.addChild(co);
        }
    }
    
    private static class Bar 
    {
      /**store cumulative value of point for this bar, only is axis_use_numbers is true. */
      public double sum;
      public Vector points = new Vector(); //list of Point
    }
    
    private static class Point
    {
      DPoint point;
      IDCoord coord;
    }
    
    private void calculateStackedAreaMinMax(DAxis ax, Arg arg)
    {
        calculateStackedBarMinMax(ax, arg);
    }
    
    private void calculateStackedBarMinMax(DAxis ax, Arg arg)
    {
        Vector bars = new Vector();
        
        
        Iterator it = arg.curves.iterator();
        while (it.hasNext())
        {
          DCurve curve = (DCurve)it.next();
          int ibar = 0;
          
          for( IDItem ip=curve.getFirstChild(); ip!=null; ip=ip.getNext(), ibar++  )
          {
            if(!(ip instanceof DPoint)) continue;
            DPoint point = (DPoint)ip;
            //get first coordinate of this point on choosen axis.
            //add check if there are a label on it.
            IDCoord coord=null;
            for( IDItem ic=ip.getFirstChild(); ic!=null; ic=ic.getNext() )
            {
              if( ic instanceof IDCoord )
              {
                IDCoord crd = (IDCoord)ic;
                if( coord==null && crd.getAxis() == ax ) coord=crd; 
              }
              if( coord!=null ) break;
            }
            //corresponding bar (coordinate MUST be found)
            if( coord!=null )
            {
              Bar bar = null;
              if( ibar>=bars.size() )
              {              
                bar = new Bar();
                bar.sum = 0;
                bars.add( bar );                              
              } else {
                bar = (Bar)bars.get(ibar);
              }
             
              //update sums:
              Point pp = new Point();
              pp.point = point;
              pp.coord = coord;            
              bar.points.add( pp );
              //cumulate value only if axis use numbers
              if( ax.useNumbers() )
              {
                double vp = ((Number)coord.getValue(null)).doubleValue();
                //!!absolute values only.            
                bar.sum += vp; //Math.abs( vp );
              }
            }
          }//points
        }//curves
        

        //prepare scale..
        arg.v_min = ax.getProperties().get( DAxis.P_MIN );
        arg.v_max = ax.getProperties().get( DAxis.P_MAX );
//    must be compared to computed values:
//        if( v_min==null ) v_min = p.axis.getProperties().get( DAxis.P_MIN_HINT );
//        if( v_max==null ) v_max = p.axis.getProperties().get( DAxis.P_MAX_HINT );
        if( arg.v_min==null || arg.v_max==null )
        {
          //if I use numbers I can
          if( ax.useNumbers() )
          {
            if( arg.v_min==null ) arg.v_min = new Double(0.0);
            if( arg.v_max==null ) 
            {
              double max=0;
              double min = 0;
              boolean init=false;
              for( it=bars.iterator(); it.hasNext(); )
              {
                double b_sum = ((Bar)it.next()).sum;
                if( init )
                { 
                    max=Math.max( max, b_sum );
                    min=Math.min(min , b_sum);  
                }
                else { max=b_sum; init=true; }
              }
              if( init )
              {
                arg.v_max = new Double(max);
                arg.v_min = new Double(min);
              }
            }
          }
        }
    }
    
    private void checkGraphic(DGraphic graph, Arg arg)
    {
        if (arg.axes.size()==0)
        {
            if (arg.nbaxes==1)
            {
                Axis ax = new Axis();
                ax.axis = new DAxis("y");
                graph.addChild(ax.axis);
                arg.axes.put(ax.axis.getName(), ax);
                ax.axis.setStyle(styles.getFirstStyle("Axis")); //$NON-NLS-1$
                
                arg.minmax_ys.put(ax.axis.getName(), new MinMax(ax.axis));
            }
            else
            if (arg.nbaxes==2)
            {   
                Axis ax = new Axis();
                ax.axis = new DAxis("x");
                graph.addChild(ax.axis);
                arg.axes.put(ax.axis.getName(), ax);
                ax.axis.setStyle(styles.getFirstStyle("Axis")); //$NON-NLS-1$
                arg.minmax_ys.put(ax.axis.getName(), new MinMax(ax.axis));
                
                ax = new Axis();
                ax.axis = new DAxis("y");
                graph.addChild(ax.axis);
                arg.axes.put(ax.axis.getName(), ax);
                ax.axis.setStyle(styles.getFirstStyle("Axis")); //$NON-NLS-1$
                arg.minmax_ys.put(ax.axis.getName(), new MinMax(ax.axis));
            }
        }
    }
    
    private double getOrderOfMagnitude(double dataMax, double dataMin) {
        double range; 
        double magnitude = 1;
        if (dataMin >= 0) {
            range = dataMax;
        } else if (dataMax <= 0) {
            range = Math.abs(dataMin);
        } else {
            range = dataMax - dataMin;
        }
        while (range > 10) {
            range /= 10;
            magnitude *= 10;
        }
        return magnitude;
    }
    
    private double getOrderOfMagnitude(double num) {
        double magnitude = 1;
        double number = Math.abs(num);
        if (number >= 1) {
            while (number >= 10) {
                number /= 10;
                magnitude *= 10;
            }
        } else if (number != 0) {
            while (number < 1) {
                number *= 10;
                magnitude *= 10;
            }
            magnitude = 1 / magnitude;
        }
        return magnitude;
    }
}
