/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DListLevel.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 18 nov. 2003
 *
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DStyle;

/**
 * Provides a class to store the list level in a JScrib document
 * during parsing the document.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DListLevel {

	 private int max = 6;
     private int level = 0;
	 protected int[] listTab = null;

	 /**
	  * Increases the list level 
	  */
     public void increase()
     {
		if (listTab == null)
	    {
		   listTab = new int[getMax()];
	    }
    
	    level = level + 1;
	    if (level > getMax())
	    {
		   level = getMax();
	    } 
      
	    for (int i = level; i < getMax(); i = i + 1)
	    {
			listTab[i] = 0;
	    }    
     }
     
     /**
      * Decreases the list level
      */
     public void decrease()
     {
		level--;
     }

     /**
      * Adds one increment in the current list level
      */
     public void newEntry()
     {
		listTab[level] = listTab[level] + 1;    
     }


	/**
	 * Returns the max of list level
	 */
	public int getMax() {
		return max;
	}

	/**
	 * Sets the list level max
	 * @param i
	 */
	public void setMax(int i) {
		max = i;
	}
   
	/**
	 * Returns the list level number in a string character
	 * with the format \format
	 * @see DTitleLevel#toFormatString
	 */
	public String toFormatString(int format) 
	{
		 String rval = null;
		 int size = -1;
		 switch (format)
		 {
			 case DStyle.GLYPH:
				  rval = "o";
				  break;
			 case DStyle.NUMBER:
				  rval = new Integer(listTab[level]).toString()+".";
				  break;
			 case DStyle.ROMAN_NUMBER:
				  //rval = new RomanNumber(listTab[listLevel]).toString()+".";
				  break;
			 case DStyle.LETTER:
				  //rval = new LetterNumber(listTab[listLevel]).toString()+".";
				  break;
			 case DStyle.NOTHING:
				  rval = "";
				  break;
			 default:
				  break;
		 }  
	  
		 return rval;    
	}	
	
	/**
	 * Returns the list number for the current level
	 */
	public int getCurrentEntryNumber() 
	{
	  if (listTab != null)
		 return listTab[level];
	  else 
	  	 return 0;
	}

	/**
	 * Returns the current list level 
	 */
	public int getLevel() {
		return level;
	}

	/**
	 * Clears the internal data. Call it before reuse this object.
	 */
	public void clear()
	{
		level = 0;
		listTab = null;
	}

}
