/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DObjectArrayContentProvider.java,v 1.4 2008/12/15 15:34:35 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.tools.internal;

import com.ibm.icu.text.UFormat;

/**
 * This class provides a tool to map a String array with two dimentions
 * to a table content provider.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DObjectArrayContentProvider implements IDTableContentProvider {

    Object [][] content;
    UFormat[] formats;
    
    /** creates a new table content provider mapped on string array */
    public DObjectArrayContentProvider(String [][] array)
    {
        setContent(array);
    }
    
    /**
     * @see org.eclipse.tptp.platform.report.tools.internal.IDTableContentProvider#getColumnCount()
     */
    public int getColumnCount() {
           return (content.length>0) ? content[0].length : 0;
    }

    /**
     * @see org.eclipse.tptp.platform.report.tools.internal.IDTableContentProvider#getRowCount()
     */
    public int getRowCount() {
        return content.length;
    }

    /**
     * @see org.eclipse.tptp.platform.report.tools.internal.IDTableContentProvider#getText(int, int)
     * Uses toString() method to return the object text string at row, column coordinates 
     */
    public String getText(int row, int column) {
        if (formats[column]!=null)
            return formats[column].format(content[row][column]);
        else
            return content[row][column].toString();
    }

    /** @return the original array mapped by the table content provider */
    public Object[][] getContent() {
        return content;
    }
    
    /** sets the string array mapped by the table content provider */
    public void setContent(String[][] content) {
        this.content = content;
        this.formats = new UFormat[content.length];
    }
    
    /** sets a com.ibm.icu.text.UFormat for the column */
    public void setColumnFormat(int column, UFormat f)
    {
        formats[column]=f;
    }
}
