/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DParser.java,v 1.4 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.tools.internal;


import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;


/**
 * DParser is a specialised DExtensible for jscrib items tree.
 * It knows how to walk in each IDItem nodes to access all IDItem of nodes tree.
 * @see DExtensible
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class DParser extends DExtensible
{
   private DListLevel listLevel = new DListLevel();	
   private DTitleLevel titleLevel = new DTitleLevel();

   /** provides an exeption class for the parser error */
   public static class ParserException extends Exception {
       /**
     * 
     */
    private static final long serialVersionUID = 1L;

    /** creates a new exception with an error message */
       public ParserException(String message)
       { super(message); }
   }
   
   /**
    * Creates a Parser
    */
   public DParser() 
   {
     super();
   }
   
   /**
    * Create a parser copying image search map from parameter.
    */
   public DParser( DParser parser )
   {
     super();
   }
   
      
   /**
    * Access method for the listLevel property.
    * 
    * @return   the current value of the listLevel property
    */
   public DListLevel getListLevel() 
   {
      return listLevel;    
   }
   
   /**
    * Access method for the titleLevel property.
    * 
    * @return   the current value of the titleLevel property
    */
   public DTitleLevel getTitleLevel() 
   {
      return titleLevel;    
   }
 
   
   /**
    * Clears the previous parsing internal datas
    */
   public void clear() 
   {	
		listLevel.clear();
		titleLevel.clear();
   }

   /**
    * Stub for IDObject class, do nothing.
    */  
   public void doMethod(IDObject i,DParser p, Object a) {};
   
   /**
    * doMethod() by extension mechanism on all children items
    */
   public void doMethod(IDItem i, DExtensible p, Object a ) { doChildrenItem(i,p,a); }   
  
   /**
    * invokeDoMethod(), on section to reach it's header and footer.
    */
   public void doMethod(DSection section,DExtensible ext,Object pa) throws ParserException
   {
	  	if (section.getHeader()!=null)
	  	    invokeDoMethod(section.getHeader(),ext,pa);
          
		if (section.getFooter()!=null)
					invokeDoMethod(section.getFooter(),ext,pa);
          
	  	doChildrenItem(section,ext,pa);
   }	  
	  
   /**
    * invokeDoMethod() for all children of IDItem  
	* @param item
	*/
   public void doChildrenItem(IDItem item, DExtensible ext, Object parser_arg ) 
   {
     if ( item==null ) return ;
	 for (IDItem i = item.getFirstChild(); i != null; i = i.getNext())
	 {
	  invokeDoMethod(i, ext, parser_arg);
	 }
   }
    
}
