/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DResultSetContentProvider.java,v 1.4 2008/12/15 15:34:35 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.tools.internal;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import com.ibm.icu.text.UFormat;

/**
 * This class provides a tool to map a String array with two dimentions
 * to a table content provider.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DResultSetContentProvider implements IDTableContentProvider {

    ResultSet content;
    UFormat[] formats;
    
    
    /** creates a new table content provider mapped on java sql request result  */
    public DResultSetContentProvider(ResultSet rset)
    {
        setContent(rset);
    }
    
    /**
     * @see org.eclipse.tptp.platform.report.tools.internal.IDTableContentProvider#getColumnCount()
     */
    public int getColumnCount() {
        try {
           ResultSetMetaData rsmd = content.getMetaData();
           return rsmd.getColumnCount();
        }
        catch (SQLException e)
        {
           return 0;
        }
    }

    /**
     * @see org.eclipse.tptp.platform.report.tools.internal.IDTableContentProvider#getRowCount()
     */
    public int getRowCount() {
        try {
          content.last();
          return content.getRow();
        }
        catch (SQLException e)
        {
            return 0;
        }
    }

    /**
     * @see org.eclipse.tptp.platform.report.tools.internal.IDTableContentProvider#getText(int, int)
     */
    public String getText(int row, int column) {
        
        try {
           ResultSetMetaData rsmd = content.getMetaData();
           content.absolute(row+1);
           if (formats[column]!=null)
               return formats[column].format(content.getObject(column));
           else
               return content.getObject(column).toString();
        }
        catch (SQLException e)
        {
            return "SQLException: e.getMessage()";
        }
    }

    /** @return the original array mapped by the table content provider */
    public ResultSet getContent() {
        return content;
    }
    
    /** sets the string array mapped by the table content provider */
    public void setContent(ResultSet content) {
        this.content = content;
        this.formats = new UFormat[getColumnCount()];
    }
    
    /** sets a com.ibm.icu.text.UFormat for the column */
    public void setColumnFormat(int column, UFormat f)
    {
        formats[column]=f;
    }
}
