/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DStackCreator.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on Oct 8, 2003
 */
package org.eclipse.tptp.platform.report.tools.internal;

import java.util.Stack;
import java.util.EmptyStackException;

import org.eclipse.tptp.platform.report.core.internal.*;

/**
 * This class is a JScrib document API authoring tool.
 * Here are the steps to be followed:
 * - create a DStackCreator instance using default constructor
 * - <i>push</i> a new DDocument
 * - <i>push</i>, <i>pop</i> or <i>add</i> any new JScrib core item
 * - <i>pop</i> the DDocument
 * Note that <i>push</i> and <i>pop</i> are to be used for containers and <i>add</i> for other items
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DStackCreator {

	/**
	 * This is the secret place where the stack of parents is stored
	 */
	private IDItem current;
	private IDItem last_child;
	private Stack parents;
	
	/**
	 * At any time, an IDItem is the current one: the one on which you <i>add</i> childs to
	 * @return the current IDItem
	 */
	public IDItem get() {
		return current;
	}

	/**
	 * Returns the first IDItem that has been pushed
	 */
	public IDItem getTop() {
		if (parents != null &&
			!parents.empty() &&
			((Parent)parents.lastElement()).getCurrent() != null) {
			return ((Parent)parents.lastElement()).getCurrent();
		}
		return current;
	}
  
	/**
	 * Returns the last IDItem that has been added as a child of the current one
	 */
	public IDItem getLast() {
		return last_child;
	}
	
	/**
	 * A private class to store what is to be stacked
	 */
	private class Parent {
		private IDItem current;
		private IDItem last_child;
		public Parent(IDItem c, IDItem l) {
			current= c;
			last_child = l;
		}
		public IDItem getCurrent() {
			return current;
		}
		public IDItem getLastChild() {
			return last_child;
		}
	}
	
	/**
	 * This is the method to be used to add a new IDItem in the document
	 * if this IDItem aims to contain childs.
	 * Otherwise, use add.
	 * Calling push() with a null item raises an Error.
	 * @param a the IDItem to be pushed
	 * @return its parameter for calls overlap
	 */
	public IDItem push(IDItem a) {
		if (a == null) {
			System.err.println(getClass()+": push(null)");
			throw new Error();
		}
		if (parents == null) {
			parents = new Stack();
		} else {
          add(a);
        }
		parents.push(new Parent(current, last_child));
		current = a;
		if (a.getFirstChild() == null) {
				last_child = null;
			}
		for (last_child = a.getFirstChild();
			 last_child != null && last_child.getNext() != null;
			 last_child = last_child.getNext());
		return a;
	}
	
	/**
	 * This is the method to call when adding childs to the current item is achieved.
	 * The parent item become the current: it is popped from the stack.
	 * Calling pop() when the internal stack is empty raises an Error.
	 * @return the new current item (previously the parent)
	 */
	public IDItem pop() {
		Parent parent = null;
		try {
			parent = (Parent)parents.pop();
		} catch (EmptyStackException e) {
		}
		if (parent == null) {
			System.err.println(getClass()+": pop() = null");
			throw new Error();
		}
		current = parent.getCurrent();
		last_child = parent.getLastChild();
		return current;
	}
	
	/**
	 * This is the method to call to add a new child to the current item.
	 * If current is null or if the item parameter can not be used as a child item
	 * of the current item, an Error is raised.
	 * @param a the item to be added as a child of the current one
	 * @return its parameter for calls overlap
	 */
	public IDItem add(IDItem a) {
		if (current == null) {
			System.err.println(getClass()+": add(IDItem) = null (no current IDItem; call push() before)");
			throw new Error();
		}
		if (!DChildrenController.acceptChild(current, a)) {
			System.err.println(getClass()+": add(IDItem) = null ("+current.getClass().getName()+" does not accept "+a.getClass().getName()+" childs)");
			throw new Error();
		} 
		if (last_child == null) {
			current.addChild(a);
		} else {
			current.insertChild(a, last_child);
		}
		last_child = a;
		return a;
	}


}
