/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DTableCreator.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.tools.internal;


import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;

/**
 * This class provides a tool to create a DTable and its content
 * by giving data from several sources: array, list and SQL
 * @see DTable
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class DTableCreator {

    
    /** @return a DTable filled with the data. A style tableStyle can be associated
     * to the cell which has been created by the method.
     * @param cellStyle define the style for all the cell which has been created
     * by the method. its value can be null 
     */
    public static DTable SimpleTable( IDTableContentProvider data, DStyle cellStyle)
    {
         DStyle[] rs = new DStyle[]{cellStyle};
         return FreeAlignmentLinedTable(data, null, null, rs, null);
    }
    
    /** @return a DTable filled with the data and add an header. A style tableStyle can be associated
     * to the cell which has been created by the method.
     * Each string of the array header is used to label the columns.
     * @see #SimpleTable(IDTableContentProvider, DStyle) 
     */
    public static DTable TableWithHeader( IDTableContentProvider data, String header[], DStyle headerStyle, DStyle cellStyle)
    {
         DStyle[] rs = new DStyle[]{cellStyle};
         return FreeAlignmentLinedTable(data, header, headerStyle, rs, null);
    }
    
    /** All columns except the first column are aligned to right (the first is aligned to the left side) 
     * @see #FreeAlignmentLinedTable(IDTableContentProvider, String[], DStyle, DStyle, DStyle, int)*/
    final public static int FIRST_LEFT_OTHERS_RIGHT = 0;
    
    /** All columns are aligned to the left side 
      * @see #FreeAlignmentLinedTable(IDTableContentProvider, String[], DStyle, DStyle, DStyle, int)*/
    final public static int ALL_LEFT = 1;
    
    /** All columns are aligned to the right side 
      * @see #FreeAlignmentLinedTable(IDTableContentProvider, String[], DStyle, DStyle, DStyle, int)*/
    final public static int ALL_RIGHT = 2;
    
    
    /** @return a DTable filled with the data.
     *  An header can be added to the table. Each string of the arrat is used to label the
     * columns. This method allows you to set a different style for the header and a style for the paired and
     * unpaired row. It allows to set an alignment type for the content in the cell of a column with 
     * the parameter colAlign. The values are: 
     * <ul>
     * <li>ALIGN_COL_FIRST_LEFT_OTHER_RIGHT
     * <li>ALIGN_COL_ALL_LEFT
     * <li>ALIGN_COL_ALL_RIGHT
     * </ul>
     * @see #TableWithHeader(IDTableContentProvider, String[], DStyle)
     */
    public static DTable LinedTableWithAlignment( IDTableContentProvider data, String header[], DStyle  headerStyle, DStyle rowPaired, DStyle rowUnPaired, int colAlign )
    {
         DStyle[] rs = new DStyle[]{rowPaired, rowUnPaired};
         int[] colal = new int[data.getColumnCount()];
         
         switch (colAlign)
         {
         case FIRST_LEFT_OTHERS_RIGHT:
              colal[0] = IDAlignment.LEFT;
              for (int i=1;i<colal.length;i++)
                  colal[i]=IDAlignment.RIGHT;
              break;
         case ALL_RIGHT:
              for (int i=0;i<colal.length;i++)
                 colal[i]=IDAlignment.RIGHT;
              break;
         case ALL_LEFT:
              for (int i=0;i<colal.length;i++)
                 colal[i]=IDAlignment.LEFT;
         default:
             
             break;
         }

         
         return FreeAlignmentLinedTable(data, header, headerStyle, rs, colal);
    }
    
    /** @return a DTable filled with the data, whith an header and a style for the header and an alignment
     * for each column.
     * @param colAlign is an array of IDAlignment values
     * @see IDAlignment
     */
    public static DTable FreeAlignmentLinedTable(IDTableContentProvider data, String header[], DStyle  headerStyle, DStyle rowStyles[], int colAlign[])
    {
        DStackCreator s = new DStackCreator();
        DTable table = new DTable();
        s.push(table);
        
        if (header!=null)
        {
            s.push(new DRow());
            int i=0;
            for (; (i<header.length) && (i<data.getColumnCount()); i++)
            {
                s.add(new DCellText(header[i]));
                if (headerStyle!=null)
                   s.getLast().setStyle(headerStyle);
                ((DCellText)s.getLast()).setAlignment(IDAlignment.CENTER);
            }
            for (; i<data.getColumnCount(); i++)
            {
                s.add(new DCell());
                if (headerStyle!=null)
                    s.getLast().setStyle(headerStyle);
                ((DCellText)s.getLast()).setAlignment(IDAlignment.CENTER);
            }   
            s.pop();
        }
        
        for (int i=0; i<data.getRowCount(); i++)
        {
            s.push(new DRow());
            for (int j=0; j<data.getColumnCount(); j++)
            {
                s.add(new DCellText(data.getText(i,j)));
                if (rowStyles!=null)
                    s.getLast().setStyle(rowStyles[i%rowStyles.length]);
                if (colAlign!=null)
                    ((DCellText)s.getLast()).setAlignment(colAlign[j]);
            }
            s.pop();
        }
    
        return table;
    }
}
