/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DTitleLevel.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 18 nov. 2003
 *
 */
package org.eclipse.tptp.platform.report.tools.internal;

/**
 * This class provides a tool to manage the title level in a document
 * It is used by the drivers.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DTitleLevel {
	   
	private int max = 6;
   
	private int level = 0;
	protected int[] tab = null;

	/**
	 * Increases of one unit the title level l
	 */
	public void increase(int l) 
	{
		if (tab == null)
		{
			 tab = new int[getMax()];  
		}
	  
		level = l<=0?1:l; // level starts at 1
		if (level > getMax())
		{
			 level = getMax();
		}
	  
		tab[level-1]++; // table starts at 0 -> titleLevel-1
	  
		for (int j = level; j < tab.length; j = j + 1)
		{
			 tab[j] = 0;
		}    
	}
   
	/**
	 * Returns the current title level in a string with the format \format
	 * Each number of level are separated by a '.' character and returned
	 * in a String.
	 * Ex: mytileLevel.toFormatString(DStyle.NUMBER) => 1.2.3.4
	 * 
	 * <I>Only format DStyle.NUMBER is implemented.</I> 
	 */
	public String toFormatString(int format) 
	{
		 String st = "";
		 int i;
		 for (i = 0; i<level-1; i++)
		 {
		   st += tab[i] + ".";
		 }
		 st += tab[i];
   	
		 return st;    
	}
   
	/**
	 * Returns the maximum of title level property
	 * @return the current value of the titleMaxLevel property
	 */
	public int getMax() 
	{
		  return max;    
	   }


	/**
	 * Clears the data of the title level
	 */
    public void clear()
    {
		level = 0;
		tab = null;
    }
    
	/**
	 * Sets the maximum of title level to manage.
	 * For example if you want to manage title like that 1.1.1.1.1 the maximum
	 * is 5.
	 */
	public void setMax(int aTitleMaxLevel) 
	{
	   max = aTitleMaxLevel;    
	}
	
	/**
	 * Returns the current pointed level
	 */
	public int getLevel() {
		return level;
	}
	
    /**
     * Returns the number of the current level.
     * Ex: 1.2.3.4 if getLevel() returns 3 then getCurrentEntryNumber() returns 4
     * 
     * @see DTitleLevel#getLevel()
     */
	public int getCurrentEntryNumber()
	{
		return tab[getLevel()];
	}

}
