/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FullGradientPalette.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

/**
 * Palette generating lots of colors from fine tuned gradient.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public  class FullGradientPalette implements IPalette
{
  int colors[];
  public FullGradientPalette( int _num_colors )
  {
    colors = new int[ _num_colors ];
  }
  public void setGradient( int from_index, int from_color, int to_index, int to_color )
  {
    if( from_index<0 ) from_index = 0; else if ( from_index >= colors.length ) from_index= colors.length-1;
    if( to_index<from_index) to_index=from_index; else if( to_index >= colors.length) to_index=colors.length-1;
    int r0 = (from_color>>16)&0xFF;      
    int g0 = (from_color>> 8)&0xFF;      
    int b0 = (from_color    )&0xFF; 
    int r1 = ((  to_color>>16)&0xFF) -r0;      
    int g1 = ((  to_color>> 8)&0xFF) -g0;      
    int b1 = ((  to_color    )&0xFF) -b0; 
    
    double k = 1.0/(double)(to_index-from_index);
    for( int i=from_index; i<=to_index; ++i )
    {
      int r = (int)( r0 + (i-from_index)*r1*k);
      int g = (int)( g0 + (i-from_index)*g1*k);
      int b = (int)( b0 + (i-from_index)*b1*k);
      colors[i] = ((r&0xFF)<<16) | ((g&0xFF)<<8) | ((b&0xFF));
    }
  }
  public int getNumColors() { return colors.length; }
  public DColor getColor( int index )
  {
    index = index % colors.length;
    int r = (colors[index]>>16)&0xFF;
    int g = (colors[index]>> 8)&0xFF;
    int b = (colors[index]    )&0xFF;
    return new DColor( r,g,b );
  }
  public int getRGBA( int index )
  {
    index = index % colors.length;
    int r = (colors[index]>>16)&0xFF;
    int g = (colors[index]>> 8)&0xFF;
    int b = (colors[index]    )&0xFF;
    return RGBA.Get( r, g, b );
  }
}
