/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GradientGeneratorPalette.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.igc.util.internal.IGradientGenerator;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

/**
 * Gradient Palette using IGradientGenerator for more than two gradient color palette.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class GradientGeneratorPalette implements IPalette
{
  protected IGradientGenerator generator_;
  protected int num_color_ ;
  public GradientGeneratorPalette( int _num_color, IGradientGenerator _generator )
  {
    generator_ = _generator;
    num_color_ = _num_color;
  }
  public int getNumColors() { return num_color_ ; }
  public DColor getColor( int index )
  {
    index = index%num_color_;
    double k = index/(double)(num_color_-1);
    int rgba = generator_.getRGBA( k );
    return new DColor( RGBA.GetR(rgba), RGBA.GetG(rgba), RGBA.GetB(rgba) );
  }
  public int getRGBA( int index )
  {
    index = index%num_color_;
    double k = index/(double)(num_color_-1);
    return generator_.getRGBA( k );
  }
}
