/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GradientPalette.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

/**
 * Palette generating numberous colors using linear interpolation between two colors.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class GradientPalette implements IPalette
{
  int num_color;
  int r0,g0,b0, r1,g1,b1;
  /** Create a simple gradient palette using two colors */
  public GradientPalette( int _num_color, int _color0, int _color1 )
  {
    num_color=_num_color;
    r0 = (_color0>>16)&0xFF;
    g0 = (_color0>> 8)&0xFF;
    b0 = (_color0    )&0xFF;
    r1 = (_color1>>16)&0xFF;
    g1 = (_color1>> 8)&0xFF;
    b1 = (_color1    )&0xFF;
  }

  public int getNumColors() { return num_color ; }
  public DColor getColor( int index )
  {
    index = index%num_color;
    double k = index/(double)(num_color-1);
    int r = (int)( r0 + k*(r1-r0));
    int g = (int)( g0 + k*(g1-g0));
    int b = (int)( b0 + k*(b1-b0));
    return new DColor( r,g,b );
  }
  public int getRGBA( int index )
  {
    index = index%num_color;
    double k = index/(double)(num_color-1);
    int r = (int)( r0 + k*(r1-r0));
    int g = (int)( g0 + k*(g1-g0));
    int b = (int)( b0 + k*(b1-b0));
    return RGBA.Get( r, g, b );
  }
}
