/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDIImageProvider.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.tools.internal;


import org.eclipse.tptp.platform.report.igc.internal.IImage;

/**
TODO: read and comment again:
 * Image provider is the way to get an IImage from underlaying graphic system and
 * various sources as Http, or file system.
 * This class have an image pool to not create Image resource each time you need, this means
 * you don't have to dispose getted Image, image provider will do ...<br>
 * It's the <u><b>responsability</b></u> of the IDIImageProvider creator to call <b>dispose</b> to free all
 * the resource image allocated by this image provider. As some modern system have limited resources,
 * do not dispose image might degenerate into a <b>"no more handle"</b> crash.<br>
 * <b>Note:</b>: This class provides IImage for IGC, those image must use pixel coordinates measure.
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDIImageProvider extends IDisposable
{
   
   /**
    * @return the image used when other image aren't found.
    */
   public IImage getBrokenImage();
   
   /**
    * Change current broken image, disposing current one before. After this call broken imag
    * is under the control of image provider, do not dispose it, image provide will do.
    */
   public void setBrokenImage(IImage image);   


   /**
    * @return image, first look into current image pool, then try to get image from an url, or
    * try from search path, file system, in the worst case return the broken image. This means you don't have
    * to <b>dispose</b> returned image, but the creator of DImageProvider must do this calling
    * IDImageProvider.dispose().
    * If an image is found, put it in current image pool, next time it will be faster...
    */
   public IImage getImage( String name ); 
   
   /**
    * sets an image into the image provider with its associated name. If the name already exists
    * into the image provider the old image will be replaced by the new one.
    * @see #getImage(String)
    */
   public void setImage( String name, IImage image ); 
   
   /**
    * @return Image currently stored in image pool, remove this image from pool.
    * After this the caller have the responsability to <b>dispose</b> taken image.
    * (as image is no longer in image pool image provider can't dispose it).
    * Return null if image isn't in pool...
    */
   public IImage takeImage( String name );
   
   /**
    * @return real file name for given image name using search path list, file must exist on file system.
    */
   public String searchImage( String ip );
 
   /**
    * Dispose all image system's resource (including broken image) held by this image provider,
    * do not forget to call this method else you'll become under hand of the "no more handle" crash...
    * The contract is: after dispose call, this object must not be further used. 
    */
   public void dispose();
  
   
   /**
    * Clear this object, do a full dispose of contained images, and clear search path and resources classes.
    */
   public void clear();
   
   /**
    * Change current search path for images, used to get image in file system.
    * set paths to null, clear current search path.
    */
   public void setImageSearchPath( String[] paths);
   
   /**
    * Clear current search path.
    */
   public void clearImageSearchPath();
   
   /**
    * Add a search path for images for search in file system, only if search path isn't already in.
    */   
   public void addImageSearchPath( String path );

   /**
    * Remove a search path for images for search in file system.
    */   
   public void removeImageSearchPath( String path );
   
   /**
    * Add a new class to get image from it's resources (do not include if class i already in)
    * @see java.lang.Class#getResourceAsStream
    */
   public void addResourceClass( Class c );
   
   /**
    * Remove a class from the resources classes.
    * @return true if class was removed, false otherwise.
    */
   public boolean removeResourceClass( Class c );
}
 
   