/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDProgressMonitor.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.tools.internal;

/**
 * Supply progress monitor for environment without eclipse.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IDProgressMonitor 
{
  public static int UNKNOWN = -1;
  
  /** Start a task identified with a name, total_works can be UNKNOWN */
  public void beginTask( String name, int total_works );
  
  /** free any resource held by task, can be called more than once */
  public void done();
  
  /** @return true if a cancel of task was requested */
  public boolean isCanceled();
  
  /** @return true if the progress is starting and not finishing */
  public boolean isInProgress();
  
  /** Request a cancel of current task. 
   *  Task must take into account this request as soon as possible */
  public void setCanceled(boolean value);
  
  /** advance current progress by work amount */
  public void worked(int work); 
  
  /** @return the task name */
  public String getTaskName();
  
  /** @return the total work count */
  public int getWorkCount();
  
  /** sets the total work */
  public void setTotalWorks(int tw);
  
  /** @return the total work */
  public int getTotalWorks();
}
