/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Palette.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.IDColor;

/**
 * Palette using array of color (see C_xxx constants), or only one color.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Palette implements IPalette
{
    
  //  Color defined as int in hex: 0xRRGGBB, means 0 to 255 to each Red,Green Blue component.
  private static int R__ = 0xFF0000;
  private static int _G_ = 0x00FF00;
  private static int __B = 0x0000FF;
  private static int RG_ = 0xFFFF00;
  private static int _GB = 0x00FFFF;
  private static int R_B = 0xFF00FF;
    
  private static int r__ = 0xA00000;
  private static int _g_ = 0x00A000;
  private static int __b = 0x0000A0;
  private static int rg_ = 0xA0A000;
  private static int _gb = 0x00A0A0;
  private static int r_b = 0xA000A0;
    
  private  static int C_Light6[] = new int[] { R__, RG_, _G_, _GB, __B, R_B };
  private  static int C_Dark6 [] = new int[] { r__, rg_, _g_, _gb, __b, r_b };
  private  static int C_LightDark12[] = new int[] { R__, RG_, _G_, _GB, __B, R_B,
                                                    r__, rg_, _g_, _gb, __b, r_b   };
  private  static int C_BW[] = new int[] { 0xFFFFFF, 0xCCCCCC, 0xAAAAAA, 0x888888, 0x777777, 0x555555, 0x333333, 0x000000 };
  //same as above, no white, no black, only gray...
  private  static int C_GRAY[] = new int[] { 0xCCCCCC, 0xAAAAAA, 0x888888, 0x777777, 0x555555, 0x333333 };  
      
  /** Default palette */
  public static final Palette PAL_DEFAULT = new Palette( C_LightDark12 );
  /** Palette using dark colors */
  public static final Palette PAL_DARK6   = new Palette( C_Dark6 );
  /** Palette using light colors */
  public static final Palette PAL_LIGHT6   = new Palette( C_Light6 );
  /** Palette using only Black, gray and White */
  public static final Palette PAL_BW      = new Palette( C_BW );
  /** Palette using only gray colors */
  public static final Palette PAL_GRAY    = new Palette( C_GRAY );
  
  int[] palette;
  public Palette( int color )
  {
    palette = new int[]{ color };
  }
  public Palette( IDColor color )
  {
    this( ((color.getRed()&0xFF)<<16) | ((color.getGreen()&0xFF)<<8) | ((color.getBlue()&0xFF)) );
  }
  public Palette( int []p )
  {
    palette=p;
  }
  public int getNumColors() { return palette.length; }
  public int getRGBA( int index )
  {
    index = index%palette.length;
    int clr = palette[index];
    return (clr<<8) | 0xFF;
  }
  public DColor getColor( int index )
  {
    index = index%palette.length;
    int c = palette[index];
    int r = (c>>16)&0xFF;
    int g = (c>> 8)&0xFF;
    int b = (c    )&0xFF;
    return new DColor( r,g,b );
  }
}
