/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SWTIImageProvider.java,v 1.4 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.tools.internal;

import java.io.InputStream;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTImage;


/**
 * Implementation of IDIImageProvider for SWT graphic system.
 * IImage returned are org.eclipse.tptp.platform.report.igc.internal.swt.SWTImage object.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SWTIImageProvider extends AbstractIImageProvider
{
   /** current device used to create images */
   private Device device_;

   /**
    * Create a new image provider operating using specified device.<br>
    * Do not forget to call <b>dispose()</b> when this object is no longer used.<br>
    * <b>Note:</b> As IImage must use pixel coordinates measure, device must be a Display.
    */
   public SWTIImageProvider( Device device )
   { 
     device_=device;
   }
   
   public Device getDevice() { return device_; }

   protected IImage createBrokenImage()
   {
     IImage img = null;
     try {
        img = 
          new SWTImage(
            new Image( device_, IDIImageProvider.class.getResourceAsStream("brokenImage.png")) );        
     } catch (Throwable t) {
        System.err.println("Cannot load image brokenImage.png");
     }
     if (img==null) img = new SWTImage( new Image( device_,30,30) );
     return img;
   }
   
   

   /**
     * Change current broken image, disposing current one before. After this call broken imag
     * is under the control of image provider, do not dispose it, image provide will do.
    */
   public void setBrokenImage(IImage image)
   {
     if( brokenImage instanceof SWTImage ) ((SWTImage)brokenImage).getImage().dispose();
     brokenImage = image;
   }

   protected IImage createImageFromFile( String filename )
   {
     if( filename==null ) return null;
     Image img=null;
     try {
       img = new Image( device_, filename );
     } catch( Throwable t ) {
       return null;
     }
     return new SWTImage( img );
   }
   
   protected IImage createImageFromInputStream( InputStream input_stream )
   {
     if( input_stream==null ) return null;
     Image img=null;
     try {
       img = new Image( device_, input_stream );
     } catch( Throwable t ) {
       return null;
     }
     return new SWTImage( img );
   }
  
   protected void disposeImage( IImage image )
   {
     if( image instanceof SWTImage )
     {
       ((SWTImage)image).disposeImage();
     }
   }

}
 
   